/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.AsynchronousFutureResult;
import com.forgerock.opendj.util.FutureResultTransformer;
import com.forgerock.opendj.util.ReferenceCountedObject;
import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.Validator;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.logging.Level;
import org.forgerock.opendj.ldap.AbstractConnectionWrapper;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.GenericExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldif.ConnectionEntryReader;

final class HeartBeatConnectionFactory
implements ConnectionFactory {
    private static final SearchRequest DEFAULT_SEARCH = Requests.newSearchRequest("", SearchScope.BASE_OBJECT, "(objectClass=*)", "1.1");
    private final List<ConnectionImpl> activeConnections;
    private final ConnectionFactory factory;
    private ScheduledFuture<?> heartBeatFuture;
    private final SearchRequest heartBeatRequest;
    private final long interval;
    private final long minDelayMS;
    private final ReferenceCountedObject.Reference scheduler;
    private final long timeoutMS;
    private final TimeUnit unit;
    private AtomicBoolean isClosed = new AtomicBoolean();

    HeartBeatConnectionFactory(ConnectionFactory factory) {
        this(factory, 10L, TimeUnit.SECONDS, DEFAULT_SEARCH, null);
    }

    HeartBeatConnectionFactory(ConnectionFactory factory, long interval, TimeUnit unit) {
        this(factory, interval, unit, DEFAULT_SEARCH, null);
    }

    HeartBeatConnectionFactory(ConnectionFactory factory, long interval, TimeUnit unit, SearchRequest heartBeat) {
        this(factory, interval, unit, heartBeat, null);
    }

    HeartBeatConnectionFactory(ConnectionFactory factory, long interval, TimeUnit unit, SearchRequest heartBeat, ScheduledExecutorService scheduler) {
        Validator.ensureNotNull((Object)factory, (Object)heartBeat, (Object)unit);
        Validator.ensureTrue(interval >= 0L, "negative timeout");
        this.heartBeatRequest = heartBeat;
        this.interval = interval;
        this.unit = unit;
        this.activeConnections = new LinkedList<ConnectionImpl>();
        this.factory = factory;
        this.scheduler = StaticUtils.DEFAULT_SCHEDULER.acquireIfNull(scheduler);
        this.timeoutMS = unit.toMillis(interval) * 2L;
        this.minDelayMS = unit.toMillis(interval) / 2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            List<ConnectionImpl> list = this.activeConnections;
            synchronized (list) {
                if (!this.activeConnections.isEmpty() && StaticUtils.DEBUG_LOG.isLoggable(Level.FINE)) {
                    StaticUtils.DEBUG_LOG.fine(String.format("HeartbeatConnectionFactory '%s' is closing while %d active connections remain", this.toString(), this.activeConnections.size()));
                }
            }
            this.scheduler.release();
            this.factory.close();
        }
    }

    @Override
    public Connection getConnection() throws ErrorResultException {
        return this.adaptConnection(this.factory.getConnection());
    }

    @Override
    public FutureResult<Connection> getConnectionAsync(ResultHandler<? super Connection> handler) {
        FutureResultTransformer<Connection, Connection> future = new FutureResultTransformer<Connection, Connection>(handler){

            @Override
            protected Connection transformResult(Connection connection) throws ErrorResultException {
                return HeartBeatConnectionFactory.this.adaptConnection(connection);
            }
        };
        future.setFutureResult(this.factory.getConnectionAsync((ResultHandler<? super Connection>)future));
        return future;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HeartBeatConnectionFactory(");
        builder.append(String.valueOf(this.factory));
        builder.append(')');
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection adaptConnection(Connection connection) {
        ConnectionImpl heartBeatConnection = new ConnectionImpl(connection);
        List<ConnectionImpl> list = this.activeConnections;
        synchronized (list) {
            connection.addConnectionEventListener(heartBeatConnection);
            if (this.activeConnections.isEmpty()) {
                this.heartBeatFuture = ((ScheduledExecutorService)this.scheduler.get()).scheduleWithFixedDelay(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ConnectionImpl[] tmp;
                        List list = HeartBeatConnectionFactory.this.activeConnections;
                        synchronized (list) {
                            tmp = HeartBeatConnectionFactory.this.activeConnections.toArray(new ConnectionImpl[0]);
                        }
                        for (ConnectionImpl connection : tmp) {
                            connection.sendHeartBeat();
                        }
                    }
                }, 0L, this.interval, this.unit);
            }
            this.activeConnections.add(heartBeatConnection);
        }
        return heartBeatConnection;
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private static final int UNLOCKED = 0;
        private static final int LOCKED_EXCLUSIVELY = -1;
        private static final long serialVersionUID = -3590428415442668336L;

        private Sync() {
        }

        @Override
        protected boolean isHeldExclusively() {
            return this.getState() == -1;
        }

        @Override
        protected boolean tryAcquire(int ignored) {
            if (this.compareAndSetState(0, -1)) {
                this.setExclusiveOwnerThread(Thread.currentThread());
                return true;
            }
            return false;
        }

        @Override
        protected int tryAcquireShared(int readers) {
            int newState;
            int state;
            do {
                if ((state = this.getState()) != -1) continue;
                return -1;
            } while (!this.compareAndSetState(state, newState = state + readers));
            return newState;
        }

        @Override
        protected boolean tryRelease(int ignored) {
            if (this.getState() != -1) {
                throw new IllegalMonitorStateException();
            }
            this.setExclusiveOwnerThread(null);
            this.setState(0);
            return true;
        }

        @Override
        protected boolean tryReleaseShared(int ignored) {
            int newState;
            int state;
            do {
                if ((state = this.getState()) != 0 && state != -1) continue;
                throw new IllegalMonitorStateException();
            } while (!this.compareAndSetState(state, newState = state - 1));
            return newState == 0;
        }

        void lockShared() {
            this.acquireShared(1);
        }

        boolean tryLockExclusively() {
            return this.tryAcquire(0);
        }

        boolean tryLockShared() {
            return this.tryAcquireShared(1) > 0;
        }

        boolean tryLockShared(long timeout, TimeUnit unit) throws InterruptedException {
            return this.tryAcquireSharedNanos(1, unit.toNanos(timeout));
        }

        void unlockExclusively() {
            this.release(0);
        }

        void unlockShared() {
            this.releaseShared(0);
        }
    }

    private final class ConnectionImpl
    extends AbstractConnectionWrapper<Connection>
    implements ConnectionEventListener,
    SearchResultHandler {
        private final Queue<Runnable> pendingRequests;
        private final Sync sync;
        private volatile long timestamp;

        private ConnectionImpl(Connection connection) {
            super(connection);
            this.pendingRequests = new ConcurrentLinkedQueue<Runnable>();
            this.sync = new Sync();
            this.timestamp = System.currentTimeMillis();
        }

        @Override
        public Result add(AddRequest request) throws ErrorResultException {
            try {
                return this.timestamp(this.connection.add(request));
            }
            catch (ErrorResultException e) {
                throw this.timestamp(e);
            }
        }

        @Override
        public Result add(Entry entry) throws ErrorResultException {
            try {
                return this.timestamp(this.connection.add(entry));
            }
            catch (ErrorResultException e) {
                throw this.timestamp(e);
            }
        }

        @Override
        public Result add(String ... ldifLines) throws ErrorResultException {
            try {
                return this.timestamp(this.connection.add(ldifLines));
            }
            catch (ErrorResultException e) {
                throw this.timestamp(e);
            }
        }

        @Override
        public FutureResult<Result> addAsync(AddRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
            return this.connection.addAsync(request, intermediateResponseHandler, this.timestamper(resultHandler));
        }

        @Override
        public BindResult bind(BindRequest request) throws ErrorResultException {
            this.acquireBindOrStartTLSLock();
            try {
                BindResult bindResult = this.timestamp(this.connection.bind(request));
                return bindResult;
            }
            catch (ErrorResultException e) {
                throw this.timestamp(e);
            }
            finally {
                this.releaseBindOrStartTLSLock();
            }
        }

        @Override
        public BindResult bind(String name, char[] password) throws ErrorResultException {
            this.acquireBindOrStartTLSLock();
            try {
                BindResult bindResult = this.timestamp(this.connection.bind(name, password));
                return bindResult;
            }
            catch (ErrorResultException e) {
                throw this.timestamp(e);
            }
            finally {
                this.releaseBindOrStartTLSLock();
            }
        }

        @Override
        public FutureResult<BindResult> bindAsync(final BindRequest request, final IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super BindResult> resultHandler) {
            if (this.sync.tryLockShared()) {
                return this.connection.bindAsync(request, intermediateResponseHandler, this.timestamper(resultHandler, true));
            }
            DelayedFuture<BindResult> future = new DelayedFuture<BindResult>(resultHandler){

                @Override
                public FutureResult<BindResult> dispatch() {
                    return ConnectionImpl.this.connection.bindAsync(request, intermediateResponseHandler, ConnectionImpl.this.timestamper(this, true));
                }
            };
            this.pendingRequests.offer(future);
            this.flushPendingRequests();
            return future;
        }

        @Override
        public CompareResult compare(CompareRequest request) throws ErrorResultException {
            try {
                return this.timestamp(this.connection.compare(request));
            }
            catch (ErrorResultException e) {
                throw this.timestamp(e);
            }
        }

        @Override
        public CompareResult compare(String name, String attributeDescription, String assertionValue) throws ErrorResultException {
            try {
                return this.timestamp(this.connection.compare(name, attributeDescription, assertionValue));
            }
            catch (ErrorResultException e) {
                throw this.timestamp(e);
            }
        }

        @Override
        public FutureResult<CompareResult> compareAsync(CompareRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super CompareResult> resultHandler) {
            return this.connection.compareAsync(request, intermediateResponseHandler, this.timestamper(resultHandler));
        }

        @Override
        public Result delete(DeleteRequest request) throws ErrorResultException {
            try {
                return this.timestamp(this.connection.delete(request));
            }
            catch (ErrorResultException e) {
                throw this.timestamp(e);
            }
        }

        @Override
        public Result delete(String name) throws ErrorResultException {
            try {
                return this.timestamp(this.connection.delete(name));
            }
            catch (ErrorResultException e) {
                throw this.timestamp(e);
            }
        }

        @Override
        public FutureResult<Result> deleteAsync(DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
            return this.connection.deleteAsync(request, intermediateResponseHandler, this.timestamper(resultHandler));
        }

        @Override
        public <R extends ExtendedResult> R extendedRequest(ExtendedRequest<R> request) throws ErrorResultException {
            boolean isStartTLS = request.getOID().equals("1.3.6.1.4.1.1466.20037");
            if (isStartTLS) {
                this.acquireBindOrStartTLSLock();
            }
            try {
                ExtendedResult extendedResult = (ExtendedResult)this.timestamp(this.connection.extendedRequest(request));
                return (R)extendedResult;
            }
            catch (ErrorResultException e) {
                throw this.timestamp(e);
            }
            finally {
                if (isStartTLS) {
                    this.releaseBindOrStartTLSLock();
                }
            }
        }

        @Override
        public <R extends ExtendedResult> R extendedRequest(ExtendedRequest<R> request, IntermediateResponseHandler handler) throws ErrorResultException {
            boolean isStartTLS = request.getOID().equals("1.3.6.1.4.1.1466.20037");
            if (isStartTLS) {
                this.acquireBindOrStartTLSLock();
            }
            try {
                ExtendedResult extendedResult = (ExtendedResult)this.timestamp(this.connection.extendedRequest(request, handler));
                return (R)extendedResult;
            }
            catch (ErrorResultException e) {
                throw this.timestamp(e);
            }
            finally {
                if (isStartTLS) {
                    this.releaseBindOrStartTLSLock();
                }
            }
        }

        @Override
        public GenericExtendedResult extendedRequest(String requestName, ByteString requestValue) throws ErrorResultException {
            boolean isStartTLS = requestName.equals("1.3.6.1.4.1.1466.20037");
            if (isStartTLS) {
                this.acquireBindOrStartTLSLock();
            }
            try {
                GenericExtendedResult genericExtendedResult = this.timestamp(this.connection.extendedRequest(requestName, requestValue));
                return genericExtendedResult;
            }
            catch (ErrorResultException e) {
                throw this.timestamp(e);
            }
            finally {
                if (isStartTLS) {
                    this.releaseBindOrStartTLSLock();
                }
            }
        }

        @Override
        public <R extends ExtendedResult> FutureResult<R> extendedRequestAsync(final ExtendedRequest<R> request, final IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super R> resultHandler) {
            boolean isStartTLS = request.getOID().equals("1.3.6.1.4.1.1466.20037");
            if (isStartTLS) {
                if (this.sync.tryLockShared()) {
                    return this.connection.extendedRequestAsync(request, intermediateResponseHandler, this.timestamper(resultHandler, true));
                }
                DelayedFuture future = new DelayedFuture<R>(resultHandler){

                    @Override
                    public FutureResult<R> dispatch() {
                        return ConnectionImpl.this.connection.extendedRequestAsync(request, intermediateResponseHandler, ConnectionImpl.this.timestamper(this, true));
                    }
                };
                this.pendingRequests.offer(future);
                this.flushPendingRequests();
                return future;
            }
            return this.connection.extendedRequestAsync(request, intermediateResponseHandler, this.timestamper(resultHandler));
        }

        @Override
        public void handleConnectionClosed() {
            this.notifyClosed();
        }

        @Override
        public void handleConnectionError(boolean isDisconnectNotification, ErrorResultException error) {
            this.notifyClosed();
        }

        @Override
        public boolean handleEntry(SearchResultEntry entry) {
            this.updateTimestamp();
            return true;
        }

        @Override
        public void handleErrorResult(ErrorResultException error) {
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINE)) {
                StaticUtils.DEBUG_LOG.fine(String.format("Heartbeat failed: %s", error.getMessage()));
            }
            this.updateTimestamp();
            this.releaseHeartBeatLock();
        }

        @Override
        public boolean handleReference(SearchResultReference reference) {
            this.updateTimestamp();
            return true;
        }

        @Override
        public void handleResult(Result result) {
            this.updateTimestamp();
            this.releaseHeartBeatLock();
        }

        @Override
        public void handleUnsolicitedNotification(ExtendedResult notification) {
            this.updateTimestamp();
        }

        @Override
        public boolean isValid() {
            return this.connection.isValid() && System.currentTimeMillis() < this.timestamp + HeartBeatConnectionFactory.this.timeoutMS;
        }

        @Override
        public Result modify(ModifyRequest request) throws ErrorResultException {
            try {
                return this.timestamp(this.connection.modify(request));
            }
            catch (ErrorResultException e) {
                throw this.timestamp(e);
            }
        }

        @Override
        public Result modify(String ... ldifLines) throws ErrorResultException {
            try {
                return this.timestamp(this.connection.modify(ldifLines));
            }
            catch (ErrorResultException e) {
                throw this.timestamp(e);
            }
        }

        @Override
        public FutureResult<Result> modifyAsync(ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
            return this.connection.modifyAsync(request, intermediateResponseHandler, this.timestamper(resultHandler));
        }

        @Override
        public Result modifyDN(ModifyDNRequest request) throws ErrorResultException {
            try {
                return this.timestamp(this.connection.modifyDN(request));
            }
            catch (ErrorResultException e) {
                throw this.timestamp(e);
            }
        }

        @Override
        public Result modifyDN(String name, String newRDN) throws ErrorResultException {
            try {
                return this.timestamp(this.connection.modifyDN(name, newRDN));
            }
            catch (ErrorResultException e) {
                throw this.timestamp(e);
            }
        }

        @Override
        public FutureResult<Result> modifyDNAsync(ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
            return this.connection.modifyDNAsync(request, intermediateResponseHandler, this.timestamper(resultHandler));
        }

        @Override
        public SearchResultEntry readEntry(DN name, String ... attributeDescriptions) throws ErrorResultException {
            try {
                return this.timestamp(this.connection.readEntry(name, attributeDescriptions));
            }
            catch (ErrorResultException e) {
                throw this.timestamp(e);
            }
        }

        @Override
        public SearchResultEntry readEntry(String name, String ... attributeDescriptions) throws ErrorResultException {
            try {
                return this.timestamp(this.connection.readEntry(name, attributeDescriptions));
            }
            catch (ErrorResultException e) {
                throw this.timestamp(e);
            }
        }

        @Override
        public FutureResult<SearchResultEntry> readEntryAsync(DN name, Collection<String> attributeDescriptions, ResultHandler<? super SearchResultEntry> handler) {
            return this.connection.readEntryAsync(name, attributeDescriptions, this.timestamper(handler));
        }

        @Override
        public ConnectionEntryReader search(SearchRequest request) {
            return new ConnectionEntryReader(this, request);
        }

        @Override
        public Result search(SearchRequest request, Collection<? super SearchResultEntry> entries) throws ErrorResultException {
            try {
                return this.timestamp(this.connection.search(request, entries));
            }
            catch (ErrorResultException e) {
                throw this.timestamp(e);
            }
        }

        @Override
        public Result search(SearchRequest request, Collection<? super SearchResultEntry> entries, Collection<? super SearchResultReference> references) throws ErrorResultException {
            try {
                return this.timestamp(this.connection.search(request, entries, references));
            }
            catch (ErrorResultException e) {
                throw this.timestamp(e);
            }
        }

        @Override
        public Result search(SearchRequest request, SearchResultHandler handler) throws ErrorResultException {
            try {
                return this.connection.search(request, this.timestamper(handler));
            }
            catch (ErrorResultException e) {
                throw this.timestamp(e);
            }
        }

        @Override
        public ConnectionEntryReader search(String baseObject, SearchScope scope, String filter, String ... attributeDescriptions) {
            SearchRequest request = Requests.newSearchRequest(baseObject, scope, filter, attributeDescriptions);
            return new ConnectionEntryReader(this, request);
        }

        @Override
        public FutureResult<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler resultHandler) {
            return this.connection.searchAsync(request, intermediateResponseHandler, this.timestamper(resultHandler));
        }

        @Override
        public SearchResultEntry searchSingleEntry(SearchRequest request) throws ErrorResultException {
            try {
                return this.timestamp(this.connection.searchSingleEntry(request));
            }
            catch (ErrorResultException e) {
                throw this.timestamp(e);
            }
        }

        @Override
        public SearchResultEntry searchSingleEntry(String baseObject, SearchScope scope, String filter, String ... attributeDescriptions) throws ErrorResultException {
            try {
                return this.timestamp(this.connection.searchSingleEntry(baseObject, scope, filter, attributeDescriptions));
            }
            catch (ErrorResultException e) {
                throw this.timestamp(e);
            }
        }

        @Override
        public FutureResult<SearchResultEntry> searchSingleEntryAsync(SearchRequest request, ResultHandler<? super SearchResultEntry> handler) {
            return this.connection.searchSingleEntryAsync(request, this.timestamper(handler));
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("HeartBeatConnection(");
            builder.append(this.connection);
            builder.append(')');
            return builder.toString();
        }

        private void acquireBindOrStartTLSLock() throws ErrorResultException {
            try {
                if (!this.sync.tryLockShared(HeartBeatConnectionFactory.this.timeoutMS, TimeUnit.MILLISECONDS)) {
                    throw ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_SERVER_DOWN);
                }
            }
            catch (InterruptedException e) {
                throw ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_USER_CANCELLED, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushPendingRequests() {
            if (!this.pendingRequests.isEmpty() && this.sync.tryLockShared()) {
                try {
                    Runnable pendingRequest;
                    while ((pendingRequest = this.pendingRequests.poll()) != null) {
                        pendingRequest.run();
                    }
                }
                finally {
                    this.sync.unlockShared();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyClosed() {
            List list = HeartBeatConnectionFactory.this.activeConnections;
            synchronized (list) {
                this.connection.removeConnectionEventListener(this);
                HeartBeatConnectionFactory.this.activeConnections.remove(this);
                if (HeartBeatConnectionFactory.this.activeConnections.isEmpty()) {
                    HeartBeatConnectionFactory.this.heartBeatFuture.cancel(false);
                }
            }
        }

        private void releaseBindOrStartTLSLock() {
            this.sync.unlockShared();
        }

        private void releaseHeartBeatLock() {
            this.sync.unlockExclusively();
            this.flushPendingRequests();
        }

        private void sendHeartBeat() {
            if (System.currentTimeMillis() < this.timestamp + HeartBeatConnectionFactory.this.minDelayMS) {
                return;
            }
            if (this.sync.tryLockExclusively()) {
                try {
                    this.connection.searchAsync(HeartBeatConnectionFactory.this.heartBeatRequest, null, this);
                }
                catch (Exception e) {
                    this.releaseHeartBeatLock();
                }
            }
        }

        private <R> R timestamp(R response) {
            this.updateTimestamp();
            return response;
        }

        private <R> ResultHandler<R> timestamper(ResultHandler<? super R> handler) {
            return this.timestamper(handler, false);
        }

        private <R> ResultHandler<R> timestamper(final ResultHandler<? super R> handler, final boolean isBindOrStartTLS) {
            return new ResultHandler<R>(){

                @Override
                public void handleErrorResult(ErrorResultException error) {
                    this.releaseIfNeeded();
                    if (handler != null) {
                        handler.handleErrorResult((ErrorResultException)ConnectionImpl.this.timestamp(error));
                    } else {
                        ConnectionImpl.this.timestamp(error);
                    }
                }

                @Override
                public void handleResult(R result) {
                    this.releaseIfNeeded();
                    if (handler != null) {
                        handler.handleResult(ConnectionImpl.this.timestamp(result));
                    } else {
                        ConnectionImpl.this.timestamp(result);
                    }
                }

                private void releaseIfNeeded() {
                    if (isBindOrStartTLS) {
                        ConnectionImpl.this.releaseBindOrStartTLSLock();
                    }
                }
            };
        }

        private SearchResultHandler timestamper(final SearchResultHandler handler) {
            return new SearchResultHandler(){

                @Override
                public boolean handleEntry(SearchResultEntry entry) {
                    return handler.handleEntry((SearchResultEntry)ConnectionImpl.this.timestamp(entry));
                }

                @Override
                public void handleErrorResult(ErrorResultException error) {
                    handler.handleErrorResult((ErrorResultException)ConnectionImpl.this.timestamp(error));
                }

                @Override
                public boolean handleReference(SearchResultReference reference) {
                    return handler.handleReference((SearchResultReference)ConnectionImpl.this.timestamp(reference));
                }

                @Override
                public void handleResult(Result result) {
                    handler.handleResult(ConnectionImpl.this.timestamp(result));
                }
            };
        }

        private void updateTimestamp() {
            this.timestamp = System.currentTimeMillis();
        }

        private abstract class DelayedFuture<R extends Result>
        extends AsynchronousFutureResult<R, ResultHandler<? super R>>
        implements Runnable {
            private volatile FutureResult<R> innerFuture;

            protected DelayedFuture(ResultHandler<? super R> handler) {
                super(handler);
                this.innerFuture = null;
            }

            @Override
            public final int getRequestID() {
                return this.innerFuture != null ? this.innerFuture.getRequestID() : -1;
            }

            @Override
            public final void run() {
                if (!this.isCancelled()) {
                    ConnectionImpl.this.sync.lockShared();
                    this.innerFuture = this.dispatch();
                    if (this.isCancelled() && !this.innerFuture.isCancelled()) {
                        this.innerFuture.cancel(false);
                    }
                }
            }

            protected abstract FutureResult<R> dispatch();

            @Override
            protected final ErrorResultException handleCancelRequest(boolean mayInterruptIfRunning) {
                if (this.innerFuture != null) {
                    this.innerFuture.cancel(mayInterruptIfRunning);
                }
                return null;
            }
        }
    }
}

