/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.AsynchronousFutureResult;
import com.forgerock.opendj.util.CompletedFutureResult;
import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.Validator;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.ConnectionPool;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.GenericExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.ConnectionEntryReader;

final class FixedConnectionPool
implements ConnectionPool {
    private final ResultHandler<Connection> connectionResultHandler = new ConnectionResultHandler();
    private final Semaphore currentPoolSize;
    private final ConnectionFactory factory;
    private boolean isClosed = false;
    private final int poolSize;
    private final LinkedList<QueueElement> queue = new LinkedList();

    FixedConnectionPool(ConnectionFactory factory, int poolSize) {
        this.factory = factory;
        this.poolSize = poolSize;
        this.currentPoolSize = new Semaphore(poolSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LinkedList<Connection> idleConnections;
        LinkedList<QueueElement> linkedList = this.queue;
        synchronized (linkedList) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            idleConnections = new LinkedList<Connection>();
            while (this.hasWaitingConnections()) {
                QueueElement holder = this.queue.removeFirst();
                idleConnections.add(holder.getWaitingConnection());
            }
        }
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINE)) {
            StaticUtils.DEBUG_LOG.fine(String.format("Connection pool is closing: currentPoolSize=%d, poolSize=%d", this.poolSize - this.currentPoolSize.availablePermits(), this.poolSize));
        }
        for (Connection connection : idleConnections) {
            this.closeConnection(connection);
        }
        this.factory.close();
    }

    @Override
    public Connection getConnection() throws ErrorResultException {
        try {
            return this.getConnectionAsync(null).get();
        }
        catch (InterruptedException e) {
            throw ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_USER_CANCELLED, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FutureResult<Connection> getConnectionAsync(ResultHandler<? super Connection> handler) {
        QueueElement holder;
        while (true) {
            LinkedList<QueueElement> linkedList = this.queue;
            synchronized (linkedList) {
                if (this.isClosed) {
                    throw new IllegalStateException("FixedConnectionPool is already closed");
                }
                if (this.hasWaitingConnections()) {
                    holder = this.queue.removeFirst();
                } else {
                    holder = new QueueElement(handler);
                    this.queue.add(holder);
                }
            }
            if (holder.isWaitingFuture()) break;
            Connection connection = holder.getWaitingConnection();
            if (connection.isValid()) {
                PooledConnection pooledConnection = new PooledConnection(connection);
                if (handler != null) {
                    handler.handleResult(pooledConnection);
                }
                return new CompletedFutureResult<Connection>(pooledConnection);
            }
            connection.close();
            this.currentPoolSize.release();
            if (!StaticUtils.DEBUG_LOG.isLoggable(Level.FINE)) continue;
            StaticUtils.DEBUG_LOG.fine(String.format("Connection no longer valid: currentPoolSize=%d, poolSize=%d", this.poolSize - this.currentPoolSize.availablePermits(), this.poolSize));
        }
        AsynchronousFutureResult<Connection, ResultHandler<? super Connection>> future = holder.getWaitingFuture();
        if (!future.isDone() && this.currentPoolSize.tryAcquire()) {
            this.factory.getConnectionAsync(this.connectionResultHandler);
        }
        return future;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FixedConnectionPool(");
        builder.append(String.valueOf(this.factory));
        builder.append(',');
        builder.append(this.poolSize);
        builder.append(')');
        return builder.toString();
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    private void closeConnection(Connection connection) {
        this.currentPoolSize.release();
        connection.close();
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINE)) {
            StaticUtils.DEBUG_LOG.fine(String.format("Closing connection because connection pool is closing: currentPoolSize=%d, poolSize=%d", this.poolSize - this.currentPoolSize.availablePermits(), this.poolSize));
        }
    }

    private boolean hasWaitingConnections() {
        return !this.queue.isEmpty() && !this.queue.getFirst().isWaitingFuture();
    }

    private boolean hasWaitingFutures() {
        return !this.queue.isEmpty() && this.queue.getFirst().isWaitingFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishConnection(Connection connection) {
        QueueElement holder;
        boolean connectionPoolIsClosing = false;
        LinkedList<QueueElement> linkedList = this.queue;
        synchronized (linkedList) {
            if (this.hasWaitingFutures()) {
                connectionPoolIsClosing = this.isClosed;
                holder = this.queue.removeFirst();
            } else if (this.isClosed) {
                connectionPoolIsClosing = true;
                holder = null;
            } else {
                QueueElement holder2 = new QueueElement(connection);
                this.queue.add(holder2);
                return;
            }
        }
        if (connectionPoolIsClosing) {
            this.closeConnection(connection);
            if (holder != null) {
                ErrorResultException e = ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_USER_CANCELLED, CoreMessages.ERR_CONNECTION_POOL_CLOSING.get((Object)this.toString()).toString());
                holder.getWaitingFuture().handleErrorResult(e);
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINE)) {
                    StaticUtils.DEBUG_LOG.fine(String.format("Connection attempt failed: %s, currentPoolSize=%d, poolSize=%d", e.getMessage(), this.poolSize - this.currentPoolSize.availablePermits(), this.poolSize));
                }
            }
        } else {
            holder.getWaitingFuture().handleResult(new PooledConnection(connection));
        }
    }

    private static final class QueueElement {
        private final Object value;

        QueueElement(Connection connection) {
            this.value = connection;
        }

        QueueElement(ResultHandler<? super Connection> handler) {
            this.value = new AsynchronousFutureResult(handler);
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        Connection getWaitingConnection() {
            if (this.value instanceof Connection) {
                return (Connection)this.value;
            }
            throw new IllegalStateException();
        }

        AsynchronousFutureResult<Connection, ResultHandler<? super Connection>> getWaitingFuture() {
            return (AsynchronousFutureResult)this.value;
        }

        boolean isWaitingFuture() {
            return this.value instanceof AsynchronousFutureResult;
        }
    }

    private final class PooledConnection
    implements Connection,
    ConnectionEventListener {
        private final Connection connection;
        private ErrorResultException error = null;
        private final AtomicBoolean isClosed = new AtomicBoolean(false);
        private boolean isDisconnectNotification = false;
        private List<ConnectionEventListener> listeners = null;
        private final Object stateLock = new Object();

        private PooledConnection(Connection connection) {
            this.connection = connection;
        }

        @Override
        public FutureResult<Void> abandonAsync(AbandonRequest request) {
            return this.checkState().abandonAsync(request);
        }

        @Override
        public Result add(AddRequest request) throws ErrorResultException {
            return this.checkState().add(request);
        }

        @Override
        public Result add(Entry entry) throws ErrorResultException {
            return this.checkState().add(entry);
        }

        @Override
        public Result add(String ... ldifLines) throws ErrorResultException {
            return this.checkState().add(ldifLines);
        }

        @Override
        public FutureResult<Result> addAsync(AddRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
            return this.checkState().addAsync(request, intermediateResponseHandler, resultHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addConnectionEventListener(ConnectionEventListener listener) {
            boolean notifyErrorOccurred;
            boolean notifyClose;
            Validator.ensureNotNull(listener);
            Object object = this.stateLock;
            synchronized (object) {
                notifyClose = this.isClosed.get();
                boolean bl = notifyErrorOccurred = this.error != null;
                if (!notifyClose) {
                    if (this.listeners == null) {
                        this.listeners = new CopyOnWriteArrayList<ConnectionEventListener>();
                        this.listeners.add(listener);
                        this.connection.addConnectionEventListener(this);
                    } else {
                        this.listeners.add(listener);
                    }
                }
            }
            if (notifyErrorOccurred) {
                listener.handleConnectionError(this.isDisconnectNotification, this.error);
            }
            if (notifyClose) {
                listener.handleConnectionClosed();
            }
        }

        @Override
        public Result applyChange(ChangeRecord request) throws ErrorResultException {
            return this.checkState().applyChange(request);
        }

        @Override
        public FutureResult<Result> applyChangeAsync(ChangeRecord request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
            return this.checkState().applyChangeAsync(request, intermediateResponseHandler, resultHandler);
        }

        @Override
        public BindResult bind(BindRequest request) throws ErrorResultException {
            return this.checkState().bind(request);
        }

        @Override
        public BindResult bind(String name, char[] password) throws ErrorResultException {
            return this.checkState().bind(name, password);
        }

        @Override
        public FutureResult<BindResult> bindAsync(BindRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super BindResult> resultHandler) {
            return this.checkState().bindAsync(request, intermediateResponseHandler, resultHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            List<ConnectionEventListener> tmpListeners;
            Object object = this.stateLock;
            synchronized (object) {
                if (!this.isClosed.compareAndSet(false, true)) {
                    return;
                }
                tmpListeners = this.listeners;
            }
            if (tmpListeners != null) {
                this.connection.removeConnectionEventListener(this);
            }
            if (this.connection.isValid()) {
                FixedConnectionPool.this.publishConnection(this.connection);
            } else {
                this.connection.close();
                FixedConnectionPool.this.factory.getConnectionAsync(FixedConnectionPool.this.connectionResultHandler);
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINE)) {
                    StaticUtils.DEBUG_LOG.fine(String.format("Connection no longer valid: currentPoolSize=%d, poolSize=%d", FixedConnectionPool.this.poolSize - FixedConnectionPool.this.currentPoolSize.availablePermits(), FixedConnectionPool.this.poolSize));
                }
            }
            if (tmpListeners != null) {
                for (ConnectionEventListener listener : tmpListeners) {
                    listener.handleConnectionClosed();
                }
            }
        }

        @Override
        public void close(UnbindRequest request, String reason) {
            this.close();
        }

        @Override
        public CompareResult compare(CompareRequest request) throws ErrorResultException {
            return this.checkState().compare(request);
        }

        @Override
        public CompareResult compare(String name, String attributeDescription, String assertionValue) throws ErrorResultException {
            return this.checkState().compare(name, attributeDescription, assertionValue);
        }

        @Override
        public FutureResult<CompareResult> compareAsync(CompareRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super CompareResult> resultHandler) {
            return this.checkState().compareAsync(request, intermediateResponseHandler, resultHandler);
        }

        @Override
        public Result delete(DeleteRequest request) throws ErrorResultException {
            return this.checkState().delete(request);
        }

        @Override
        public Result delete(String name) throws ErrorResultException {
            return this.checkState().delete(name);
        }

        @Override
        public FutureResult<Result> deleteAsync(DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
            return this.checkState().deleteAsync(request, intermediateResponseHandler, resultHandler);
        }

        @Override
        public Result deleteSubtree(String name) throws ErrorResultException {
            return this.checkState().deleteSubtree(name);
        }

        @Override
        public <R extends ExtendedResult> R extendedRequest(ExtendedRequest<R> request) throws ErrorResultException {
            return this.checkState().extendedRequest(request);
        }

        @Override
        public <R extends ExtendedResult> R extendedRequest(ExtendedRequest<R> request, IntermediateResponseHandler handler) throws ErrorResultException {
            return this.checkState().extendedRequest(request, handler);
        }

        @Override
        public GenericExtendedResult extendedRequest(String requestName, ByteString requestValue) throws ErrorResultException {
            return this.checkState().extendedRequest(requestName, requestValue);
        }

        @Override
        public <R extends ExtendedResult> FutureResult<R> extendedRequestAsync(ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super R> resultHandler) {
            return this.checkState().extendedRequestAsync(request, intermediateResponseHandler, resultHandler);
        }

        @Override
        public void handleConnectionClosed() {
            throw new IllegalStateException("Pooled connection received unexpected close notification");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleConnectionError(boolean isDisconnectNotification, ErrorResultException error) {
            List<ConnectionEventListener> tmpListeners;
            Object object = this.stateLock;
            synchronized (object) {
                tmpListeners = this.listeners;
                this.isDisconnectNotification = isDisconnectNotification;
                this.error = error;
            }
            if (tmpListeners != null) {
                for (ConnectionEventListener listener : tmpListeners) {
                    listener.handleConnectionError(isDisconnectNotification, error);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleUnsolicitedNotification(ExtendedResult notification) {
            List<ConnectionEventListener> tmpListeners;
            Object object = this.stateLock;
            synchronized (object) {
                tmpListeners = this.listeners;
            }
            if (tmpListeners != null) {
                for (ConnectionEventListener listener : tmpListeners) {
                    listener.handleUnsolicitedNotification(notification);
                }
            }
        }

        @Override
        public boolean isClosed() {
            return this.isClosed.get();
        }

        @Override
        public boolean isValid() {
            return this.connection.isValid() && !this.isClosed();
        }

        @Override
        public Result modify(ModifyRequest request) throws ErrorResultException {
            return this.checkState().modify(request);
        }

        @Override
        public Result modify(String ... ldifLines) throws ErrorResultException {
            return this.checkState().modify(ldifLines);
        }

        @Override
        public FutureResult<Result> modifyAsync(ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
            return this.checkState().modifyAsync(request, intermediateResponseHandler, resultHandler);
        }

        @Override
        public Result modifyDN(ModifyDNRequest request) throws ErrorResultException {
            return this.checkState().modifyDN(request);
        }

        @Override
        public Result modifyDN(String name, String newRDN) throws ErrorResultException {
            return this.checkState().modifyDN(name, newRDN);
        }

        @Override
        public FutureResult<Result> modifyDNAsync(ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
            return this.checkState().modifyDNAsync(request, intermediateResponseHandler, resultHandler);
        }

        @Override
        public SearchResultEntry readEntry(DN name, String ... attributeDescriptions) throws ErrorResultException {
            return this.checkState().readEntry(name, attributeDescriptions);
        }

        @Override
        public SearchResultEntry readEntry(String name, String ... attributeDescriptions) throws ErrorResultException {
            return this.checkState().readEntry(name, attributeDescriptions);
        }

        @Override
        public FutureResult<SearchResultEntry> readEntryAsync(DN name, Collection<String> attributeDescriptions, ResultHandler<? super SearchResultEntry> handler) {
            return this.checkState().readEntryAsync(name, attributeDescriptions, handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeConnectionEventListener(ConnectionEventListener listener) {
            Validator.ensureNotNull(listener);
            Object object = this.stateLock;
            synchronized (object) {
                if (this.listeners != null) {
                    this.listeners.remove(listener);
                }
            }
        }

        @Override
        public ConnectionEntryReader search(SearchRequest request) {
            return this.checkState().search(request);
        }

        @Override
        public Result search(SearchRequest request, Collection<? super SearchResultEntry> entries) throws ErrorResultException {
            return this.checkState().search(request, entries);
        }

        @Override
        public Result search(SearchRequest request, Collection<? super SearchResultEntry> entries, Collection<? super SearchResultReference> references) throws ErrorResultException {
            return this.checkState().search(request, entries, references);
        }

        @Override
        public Result search(SearchRequest request, SearchResultHandler handler) throws ErrorResultException {
            return this.checkState().search(request, handler);
        }

        @Override
        public ConnectionEntryReader search(String baseObject, SearchScope scope, String filter, String ... attributeDescriptions) {
            return this.checkState().search(baseObject, scope, filter, attributeDescriptions);
        }

        @Override
        public FutureResult<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler resultHandler) {
            return this.checkState().searchAsync(request, intermediateResponseHandler, resultHandler);
        }

        @Override
        public SearchResultEntry searchSingleEntry(SearchRequest request) throws ErrorResultException {
            return this.checkState().searchSingleEntry(request);
        }

        @Override
        public SearchResultEntry searchSingleEntry(String baseObject, SearchScope scope, String filter, String ... attributeDescriptions) throws ErrorResultException {
            return this.checkState().searchSingleEntry(baseObject, scope, filter, attributeDescriptions);
        }

        @Override
        public FutureResult<SearchResultEntry> searchSingleEntryAsync(SearchRequest request, ResultHandler<? super SearchResultEntry> handler) {
            return this.checkState().searchSingleEntryAsync(request, handler);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("PooledConnection(");
            builder.append(this.connection);
            builder.append(')');
            return builder.toString();
        }

        private Connection checkState() {
            if (this.isClosed()) {
                throw new IllegalStateException();
            }
            return this.connection;
        }
    }

    private final class ConnectionResultHandler
    implements ResultHandler<Connection> {
        private ConnectionResultHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleErrorResult(ErrorResultException error) {
            QueueElement holder;
            FixedConnectionPool.this.currentPoolSize.release();
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINE)) {
                StaticUtils.DEBUG_LOG.fine(String.format("Connection attempt failed: %s, currentPoolSize=%d, poolSize=%d", error.getMessage(), FixedConnectionPool.this.poolSize - FixedConnectionPool.this.currentPoolSize.availablePermits(), FixedConnectionPool.this.poolSize));
            }
            LinkedList linkedList = FixedConnectionPool.this.queue;
            synchronized (linkedList) {
                if (!FixedConnectionPool.this.hasWaitingFutures()) {
                    return;
                }
                holder = (QueueElement)FixedConnectionPool.this.queue.removeFirst();
            }
            holder.getWaitingFuture().handleErrorResult(error);
        }

        @Override
        public void handleResult(Connection connection) {
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINE)) {
                StaticUtils.DEBUG_LOG.fine(String.format("Connection attempt succeeded:  currentPoolSize=%d, poolSize=%d", FixedConnectionPool.this.poolSize - FixedConnectionPool.this.currentPoolSize.availablePermits(), FixedConnectionPool.this.poolSize));
            }
            FixedConnectionPool.this.publishConnection(connection);
        }
    }
}

