/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.Iterables;
import com.forgerock.opendj.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.AttributeParser;
import org.forgerock.opendj.ldap.Attributes;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.Function;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.TreeMapEntry;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.ObjectClassType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaValidationPolicy;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;

public final class Entries {
    private static final Comparator<Entry> COMPARATOR = new Comparator<Entry>(){

        @Override
        public int compare(Entry o1, Entry o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final Function<Attribute, Attribute, Void> UNMODIFIABLE_ATTRIBUTE_FUNCTION = new Function<Attribute, Attribute, Void>(){

        @Override
        public Attribute apply(Attribute value, Void p) {
            return Attributes.unmodifiableAttribute(value);
        }
    };

    public static Comparator<Entry> compareByName() {
        return COMPARATOR;
    }

    public static boolean conformsToSchema(Entry entry, Schema schema, SchemaValidationPolicy policy, Collection<LocalizableMessage> errorMessages) {
        return schema.validateEntry(entry, policy, errorMessages);
    }

    public static boolean conformsToSchema(Entry entry, SchemaValidationPolicy policy, Collection<LocalizableMessage> errorMessages) {
        return Entries.conformsToSchema(entry, Schema.getDefaultSchema(), policy, errorMessages);
    }

    public static ModifyRequest diffEntries(Entry fromEntry, Entry toEntry) {
        Attribute a;
        Attribute ato;
        Validator.ensureNotNull((Object)fromEntry, (Object)toEntry);
        ModifyRequest request = Requests.newModifyRequest(fromEntry.getName());
        TreeMapEntry tfrom = fromEntry instanceof TreeMapEntry ? (TreeMapEntry)fromEntry : new TreeMapEntry(fromEntry);
        TreeMapEntry tto = toEntry instanceof TreeMapEntry ? (TreeMapEntry)toEntry : new TreeMapEntry(toEntry);
        Iterator<Attribute> ifrom = tfrom.getAllAttributes().iterator();
        Iterator<Attribute> ito = tto.getAllAttributes().iterator();
        Attribute afrom = ifrom.hasNext() ? ifrom.next() : null;
        Attribute attribute = ato = ito.hasNext() ? ito.next() : null;
        while (afrom != null && ato != null) {
            AttributeDescription adto;
            AttributeDescription adfrom = afrom.getAttributeDescription();
            int cmp = adfrom.compareTo(adto = ato.getAttributeDescription());
            if (cmp == 0) {
                LinkedAttribute addedValues = new LinkedAttribute(ato);
                addedValues.removeAll(afrom);
                if (!addedValues.isEmpty()) {
                    request.addModification(new Modification(ModificationType.ADD, addedValues));
                }
                LinkedAttribute deletedValues = new LinkedAttribute(afrom);
                deletedValues.removeAll(ato);
                if (!deletedValues.isEmpty()) {
                    request.addModification(new Modification(ModificationType.DELETE, deletedValues));
                }
                afrom = ifrom.hasNext() ? ifrom.next() : null;
                ato = ito.hasNext() ? ito.next() : null;
                continue;
            }
            if (cmp < 0) {
                request.addModification(new Modification(ModificationType.DELETE, afrom));
                afrom = ifrom.hasNext() ? ifrom.next() : null;
                continue;
            }
            request.addModification(new Modification(ModificationType.ADD, ato));
            ato = ito.hasNext() ? ito.next() : null;
        }
        if (afrom != null) {
            request.addModification(new Modification(ModificationType.DELETE, afrom));
        }
        while (ifrom.hasNext()) {
            a = ifrom.next();
            request.addModification(new Modification(ModificationType.DELETE, a));
        }
        if (ato != null) {
            request.addModification(new Modification(ModificationType.ADD, ato));
        }
        while (ito.hasNext()) {
            a = ito.next();
            request.addModification(new Modification(ModificationType.ADD, a));
        }
        return request;
    }

    public static Set<ObjectClass> getObjectClasses(Entry entry) {
        return Entries.getObjectClasses(entry, Schema.getDefaultSchema());
    }

    public static Set<ObjectClass> getObjectClasses(Entry entry, Schema schema) {
        Attribute objectClassAttribute = entry.getAttribute(AttributeDescription.objectClass());
        if (objectClassAttribute == null) {
            return Collections.emptySet();
        }
        HashSet<ObjectClass> objectClasses = new HashSet<ObjectClass>(objectClassAttribute.size());
        for (ByteString v : objectClassAttribute) {
            String objectClassName = v.toString();
            try {
                ObjectClass objectClass = schema.getObjectClass(objectClassName);
                objectClasses.add(objectClass);
            }
            catch (UnknownSchemaElementException e) {}
        }
        return Collections.unmodifiableSet(objectClasses);
    }

    public static ObjectClass getStructuralObjectClass(Entry entry) {
        return Entries.getStructuralObjectClass(entry, Schema.getDefaultSchema());
    }

    public static ObjectClass getStructuralObjectClass(Entry entry, Schema schema) {
        ObjectClass structuralObjectClass = null;
        Attribute objectClassAttribute = entry.getAttribute(AttributeDescription.objectClass());
        if (objectClassAttribute == null) {
            return null;
        }
        for (ByteString v : objectClassAttribute) {
            ObjectClass objectClass;
            String objectClassName = v.toString();
            try {
                objectClass = schema.getObjectClass(objectClassName);
            }
            catch (UnknownSchemaElementException e) {
                continue;
            }
            if (objectClass.getObjectClassType() != ObjectClassType.STRUCTURAL || structuralObjectClass != null && !objectClass.isDescendantOf(structuralObjectClass)) continue;
            structuralObjectClass = objectClass;
        }
        return structuralObjectClass;
    }

    public static Entry modifyEntry(Entry entry, Modification change) throws ErrorResultException {
        return Entries.modifyEntry(entry, change, null);
    }

    public static Entry modifyEntry(Entry entry, Modification change, Collection<? super ByteString> conflictingValues) throws ErrorResultException {
        ModificationType modType = change.getModificationType();
        if (modType.equals(ModificationType.ADD)) {
            entry.addAttribute(change.getAttribute(), conflictingValues);
        } else if (modType.equals(ModificationType.DELETE)) {
            entry.removeAttribute(change.getAttribute(), conflictingValues);
        } else if (modType.equals(ModificationType.REPLACE)) {
            entry.replaceAttribute(change.getAttribute());
        } else if (modType.equals(ModificationType.INCREMENT)) {
            Entries.incrementAttribute(entry, change.getAttribute());
        } else {
            throw ErrorResultException.newErrorResult(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_ENTRY_UNKNOWN_MODIFICATION_TYPE.get((Object)String.valueOf(modType)).toString());
        }
        return entry;
    }

    public static Entry modifyEntry(Entry entry, ModifyRequest changes) throws ErrorResultException {
        boolean isPermissive = changes.containsControl("1.2.840.113556.1.4.1413");
        return Entries.modifyEntry0(entry, changes.getModifications(), isPermissive);
    }

    public static Entry modifyEntryPermissive(Entry entry, Collection<Modification> changes) throws ErrorResultException {
        return Entries.modifyEntry0(entry, changes, true);
    }

    public static Entry modifyEntryStrict(Entry entry, Collection<Modification> changes) throws ErrorResultException {
        return Entries.modifyEntry0(entry, changes, false);
    }

    public static Entry unmodifiableEntry(Entry entry) {
        if (entry instanceof UnmodifiableEntry) {
            return entry;
        }
        return new UnmodifiableEntry(entry);
    }

    private static void incrementAttribute(Entry entry, Attribute change) throws ErrorResultException {
        long delta;
        AttributeDescription deltaAd = change.getAttributeDescription();
        if (change.size() != 1) {
            throw ErrorResultException.newErrorResult(ResultCode.CONSTRAINT_VIOLATION, CoreMessages.ERR_ENTRY_INCREMENT_INVALID_VALUE_COUNT.get((Object)deltaAd.toString()).toString());
        }
        try {
            delta = change.parse().asLong();
        }
        catch (Exception e) {
            throw ErrorResultException.newErrorResult(ResultCode.CONSTRAINT_VIOLATION, CoreMessages.ERR_ENTRY_INCREMENT_CANNOT_PARSE_AS_INT.get((Object)deltaAd.toString()).toString());
        }
        Attribute oldAttribute = entry.getAttribute(deltaAd);
        if (oldAttribute == null) {
            throw ErrorResultException.newErrorResult(ResultCode.NO_SUCH_ATTRIBUTE, CoreMessages.ERR_ENTRY_INCREMENT_NO_SUCH_ATTRIBUTE.get((Object)deltaAd.toString()).toString());
        }
        LinkedAttribute newAttribute = new LinkedAttribute(oldAttribute.getAttributeDescription());
        try {
            for (Long value : oldAttribute.parse().asSetOfLong(new Long[0])) {
                newAttribute.add(new Object[]{value + delta});
            }
        }
        catch (Exception e) {
            throw ErrorResultException.newErrorResult(ResultCode.CONSTRAINT_VIOLATION, CoreMessages.ERR_ENTRY_INCREMENT_CANNOT_PARSE_AS_INT.get((Object)deltaAd.toString()).toString());
        }
        entry.replaceAttribute(newAttribute);
    }

    private static Entry modifyEntry0(Entry entry, Collection<Modification> changes, boolean isPermissive) throws ErrorResultException {
        ArrayList conflictingValues = isPermissive ? null : new ArrayList(0);
        for (Modification change : changes) {
            Entries.modifyEntry(entry, change, conflictingValues);
            if (isPermissive || conflictingValues.isEmpty()) continue;
            if (change.getModificationType().equals(ModificationType.ADD)) {
                throw ErrorResultException.newErrorResult(ResultCode.ATTRIBUTE_OR_VALUE_EXISTS, CoreMessages.ERR_ENTRY_DUPLICATE_VALUES.get((Object)change.getAttribute().getAttributeDescriptionAsString()).toString());
            }
            throw ErrorResultException.newErrorResult(ResultCode.NO_SUCH_ATTRIBUTE, CoreMessages.ERR_ENTRY_NO_SUCH_VALUE.get((Object)change.getAttribute().getAttributeDescriptionAsString()).toString());
        }
        return entry;
    }

    private Entries() {
    }

    private static final class UnmodifiableEntry
    implements Entry {
        private final Entry entry;

        private UnmodifiableEntry(Entry entry) {
            this.entry = entry;
        }

        @Override
        public boolean addAttribute(Attribute attribute) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAttribute(Attribute attribute, Collection<? super ByteString> duplicateValues) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Entry addAttribute(String attributeDescription, Object ... values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Entry clearAttributes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAttribute(Attribute attribute, Collection<? super ByteString> missingValues) {
            return this.entry.containsAttribute(attribute, missingValues);
        }

        @Override
        public boolean containsAttribute(String attributeDescription, Object ... values) {
            return this.entry.containsAttribute(attributeDescription, values);
        }

        @Override
        public boolean equals(Object object) {
            return object == this || this.entry.equals(object);
        }

        @Override
        public Iterable<Attribute> getAllAttributes() {
            return Iterables.unmodifiableIterable(Iterables.transformedIterable(this.entry.getAllAttributes(), UNMODIFIABLE_ATTRIBUTE_FUNCTION));
        }

        @Override
        public Iterable<Attribute> getAllAttributes(AttributeDescription attributeDescription) {
            return Iterables.unmodifiableIterable(Iterables.transformedIterable(this.entry.getAllAttributes(attributeDescription), UNMODIFIABLE_ATTRIBUTE_FUNCTION));
        }

        @Override
        public Iterable<Attribute> getAllAttributes(String attributeDescription) {
            return Iterables.unmodifiableIterable(Iterables.transformedIterable(this.entry.getAllAttributes(attributeDescription), UNMODIFIABLE_ATTRIBUTE_FUNCTION));
        }

        @Override
        public Attribute getAttribute(AttributeDescription attributeDescription) {
            Attribute attribute = this.entry.getAttribute(attributeDescription);
            if (attribute != null) {
                return Attributes.unmodifiableAttribute(attribute);
            }
            return null;
        }

        @Override
        public Attribute getAttribute(String attributeDescription) {
            Attribute attribute = this.entry.getAttribute(attributeDescription);
            if (attribute != null) {
                return Attributes.unmodifiableAttribute(attribute);
            }
            return null;
        }

        @Override
        public int getAttributeCount() {
            return this.entry.getAttributeCount();
        }

        @Override
        public DN getName() {
            return this.entry.getName();
        }

        @Override
        public int hashCode() {
            return this.entry.hashCode();
        }

        @Override
        public AttributeParser parseAttribute(AttributeDescription attributeDescription) {
            return this.entry.parseAttribute(attributeDescription);
        }

        @Override
        public AttributeParser parseAttribute(String attributeDescription) {
            return this.entry.parseAttribute(attributeDescription);
        }

        @Override
        public boolean removeAttribute(Attribute attribute, Collection<? super ByteString> missingValues) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAttribute(AttributeDescription attributeDescription) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Entry removeAttribute(String attributeDescription, Object ... values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean replaceAttribute(Attribute attribute) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Entry replaceAttribute(String attributeDescription, Object ... values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Entry setName(DN dn) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Entry setName(String dn) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            return this.entry.toString();
        }
    }
}

