/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.InternalConnection;
import com.forgerock.opendj.util.Validator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.forgerock.opendj.ldap.AbstractConnectionWrapper;
import org.forgerock.opendj.ldap.AuthenticatedConnectionFactory;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.ConnectionPool;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FixedConnectionPool;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.HeartBeatConnectionFactory;
import org.forgerock.opendj.ldap.InternalConnectionFactory;
import org.forgerock.opendj.ldap.LoadBalancer;
import org.forgerock.opendj.ldap.LoadBalancingAlgorithm;
import org.forgerock.opendj.ldap.RequestContext;
import org.forgerock.opendj.ldap.RequestHandler;
import org.forgerock.opendj.ldap.RequestHandlerFactory;
import org.forgerock.opendj.ldap.RequestHandlerFactoryAdapter;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.ServerConnection;
import org.forgerock.opendj.ldap.ServerConnectionFactory;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;

public final class Connections {
    public static ConnectionFactory newAuthenticatedConnectionFactory(ConnectionFactory factory, BindRequest request) {
        Validator.ensureNotNull((Object)factory, (Object)request);
        return new AuthenticatedConnectionFactory(factory, request);
    }

    public static ConnectionPool newFixedConnectionPool(ConnectionFactory factory, int poolSize) {
        Validator.ensureNotNull(factory);
        Validator.ensureTrue(poolSize >= 0, "negative pool size");
        return new FixedConnectionPool(factory, poolSize);
    }

    public static ConnectionFactory newHeartBeatConnectionFactory(ConnectionFactory factory) {
        return new HeartBeatConnectionFactory(factory);
    }

    public static ConnectionFactory newHeartBeatConnectionFactory(ConnectionFactory factory, long interval, TimeUnit unit) {
        return new HeartBeatConnectionFactory(factory, interval, unit);
    }

    public static ConnectionFactory newHeartBeatConnectionFactory(ConnectionFactory factory, long interval, TimeUnit unit, SearchRequest heartBeat) {
        return new HeartBeatConnectionFactory(factory, interval, unit, heartBeat);
    }

    public static ConnectionFactory newHeartBeatConnectionFactory(ConnectionFactory factory, long interval, TimeUnit unit, SearchRequest heartBeat, ScheduledExecutorService scheduler) {
        return new HeartBeatConnectionFactory(factory, interval, unit, heartBeat, scheduler);
    }

    public static Connection newInternalConnection(RequestHandler<RequestContext> requestHandler) {
        Validator.ensureNotNull(requestHandler);
        return Connections.newInternalConnection(RequestHandlerFactoryAdapter.adaptRequestHandler(requestHandler));
    }

    public static Connection newInternalConnection(ServerConnection<Integer> serverConnection) {
        Validator.ensureNotNull(serverConnection);
        return new InternalConnection(serverConnection);
    }

    public static ConnectionFactory newInternalConnectionFactory(RequestHandler<RequestContext> requestHandler) {
        Validator.ensureNotNull(requestHandler);
        return new InternalConnectionFactory<Object>(Connections.newServerConnectionFactory(requestHandler), null);
    }

    public static <C> ConnectionFactory newInternalConnectionFactory(RequestHandlerFactory<C, RequestContext> factory, C clientContext) {
        Validator.ensureNotNull(factory);
        return new InternalConnectionFactory<C>(Connections.newServerConnectionFactory(factory), clientContext);
    }

    public static <C> ConnectionFactory newInternalConnectionFactory(ServerConnectionFactory<C, Integer> factory, C clientContext) {
        Validator.ensureNotNull(factory);
        return new InternalConnectionFactory<C>(factory, clientContext);
    }

    public static ConnectionFactory newLoadBalancer(LoadBalancingAlgorithm algorithm) {
        return new LoadBalancer(algorithm);
    }

    public static ConnectionFactory newNamedConnectionFactory(final ConnectionFactory factory, final String name) {
        Validator.ensureNotNull((Object)factory, (Object)name);
        return new ConnectionFactory(){

            @Override
            public void close() {
                factory.close();
            }

            @Override
            public Connection getConnection() throws ErrorResultException {
                return factory.getConnection();
            }

            @Override
            public FutureResult<Connection> getConnectionAsync(ResultHandler<? super Connection> handler) {
                return factory.getConnectionAsync(handler);
            }

            public String toString() {
                return name;
            }
        };
    }

    public static <C> ServerConnectionFactory<C, Integer> newServerConnectionFactory(final RequestHandler<RequestContext> requestHandler) {
        Validator.ensureNotNull(requestHandler);
        return new RequestHandlerFactoryAdapter(new RequestHandlerFactory<C, RequestContext>(){

            @Override
            public RequestHandler<RequestContext> handleAccept(C clientContext) {
                return requestHandler;
            }
        });
    }

    public static <C> ServerConnectionFactory<C, Integer> newServerConnectionFactory(RequestHandlerFactory<C, RequestContext> factory) {
        Validator.ensureNotNull(factory);
        return new RequestHandlerFactoryAdapter<C>(factory);
    }

    public static Connection uncloseable(Connection connection) {
        return new AbstractConnectionWrapper<Connection>(connection){

            @Override
            public void close() {
            }

            @Override
            public void close(UnbindRequest request, String reason) {
            }
        };
    }

    public static ConnectionFactory uncloseable(final ConnectionFactory factory) {
        return new ConnectionFactory(){

            @Override
            public FutureResult<Connection> getConnectionAsync(ResultHandler<? super Connection> handler) {
                return factory.getConnectionAsync(handler);
            }

            @Override
            public Connection getConnection() throws ErrorResultException {
                return factory.getConnection();
            }

            @Override
            public void close() {
            }
        };
    }

    private Connections() {
    }
}

