/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.CompletedFutureResult;
import org.forgerock.opendj.ldap.AbstractConnection;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;

public abstract class AbstractSynchronousConnection
extends AbstractConnection {
    protected AbstractSynchronousConnection() {
    }

    @Override
    public FutureResult<Void> abandonAsync(AbandonRequest request) {
        throw new UnsupportedOperationException("Abandon requests are not supported for synchronous connections");
    }

    @Override
    public FutureResult<Result> addAsync(AddRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
        try {
            return this.onSuccess(this.add(request), resultHandler);
        }
        catch (ErrorResultException e) {
            return this.onFailure(e, resultHandler);
        }
    }

    @Override
    public FutureResult<BindResult> bindAsync(BindRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super BindResult> resultHandler) {
        try {
            return this.onSuccess(this.bind(request), resultHandler);
        }
        catch (ErrorResultException e) {
            return this.onFailure(e, resultHandler);
        }
    }

    @Override
    public FutureResult<CompareResult> compareAsync(CompareRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super CompareResult> resultHandler) {
        try {
            return this.onSuccess(this.compare(request), resultHandler);
        }
        catch (ErrorResultException e) {
            return this.onFailure(e, resultHandler);
        }
    }

    @Override
    public FutureResult<Result> deleteAsync(DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
        try {
            return this.onSuccess(this.delete(request), resultHandler);
        }
        catch (ErrorResultException e) {
            return this.onFailure(e, resultHandler);
        }
    }

    @Override
    public <R extends ExtendedResult> FutureResult<R> extendedRequestAsync(ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super R> resultHandler) {
        try {
            return this.onSuccess(this.extendedRequest(request, intermediateResponseHandler), resultHandler);
        }
        catch (ErrorResultException e) {
            return this.onFailure(e, resultHandler);
        }
    }

    @Override
    public FutureResult<Result> modifyAsync(ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
        try {
            return this.onSuccess(this.modify(request), resultHandler);
        }
        catch (ErrorResultException e) {
            return this.onFailure(e, resultHandler);
        }
    }

    @Override
    public FutureResult<Result> modifyDNAsync(ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
        try {
            return this.onSuccess(this.modifyDN(request), resultHandler);
        }
        catch (ErrorResultException e) {
            return this.onFailure(e, resultHandler);
        }
    }

    @Override
    public FutureResult<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler resultHandler) {
        try {
            return this.onSuccess(this.search(request, resultHandler), resultHandler);
        }
        catch (ErrorResultException e) {
            return this.onFailure(e, resultHandler);
        }
    }

    private <R extends Result> FutureResult<R> onFailure(ErrorResultException e, ResultHandler<? super R> resultHandler) {
        if (resultHandler != null) {
            resultHandler.handleErrorResult(e);
        }
        return new CompletedFutureResult(e);
    }

    private <R extends Result> FutureResult<R> onSuccess(R result, ResultHandler<? super R> resultHandler) {
        if (resultHandler != null) {
            resultHandler.handleResult(result);
        }
        return new CompletedFutureResult<R>(result);
    }
}

