/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.Validator;
import java.util.Collection;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.GenericExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.ConnectionEntryReader;

public abstract class AbstractConnectionWrapper<C extends Connection>
implements Connection {
    protected final C connection;

    protected AbstractConnectionWrapper(C connection) {
        Validator.ensureNotNull(connection);
        this.connection = connection;
    }

    @Override
    public FutureResult<Void> abandonAsync(AbandonRequest request) {
        return this.connection.abandonAsync(request);
    }

    @Override
    public Result add(AddRequest request) throws ErrorResultException {
        return this.connection.add(request);
    }

    @Override
    public Result add(Entry entry) throws ErrorResultException {
        return this.connection.add(entry);
    }

    @Override
    public Result add(String ... ldifLines) throws ErrorResultException {
        return this.connection.add(ldifLines);
    }

    @Override
    public FutureResult<Result> addAsync(AddRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
        return this.connection.addAsync(request, intermediateResponseHandler, resultHandler);
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.connection.addConnectionEventListener(listener);
    }

    @Override
    public Result applyChange(ChangeRecord request) throws ErrorResultException {
        return this.connection.applyChange(request);
    }

    @Override
    public FutureResult<Result> applyChangeAsync(ChangeRecord request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
        return this.connection.applyChangeAsync(request, intermediateResponseHandler, resultHandler);
    }

    @Override
    public BindResult bind(BindRequest request) throws ErrorResultException {
        return this.connection.bind(request);
    }

    @Override
    public BindResult bind(String name, char[] password) throws ErrorResultException {
        return this.connection.bind(name, password);
    }

    @Override
    public FutureResult<BindResult> bindAsync(BindRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super BindResult> resultHandler) {
        return this.connection.bindAsync(request, intermediateResponseHandler, resultHandler);
    }

    @Override
    public void close() {
        this.connection.close();
    }

    @Override
    public void close(UnbindRequest request, String reason) {
        this.connection.close(request, reason);
    }

    @Override
    public CompareResult compare(CompareRequest request) throws ErrorResultException {
        return this.connection.compare(request);
    }

    @Override
    public CompareResult compare(String name, String attributeDescription, String assertionValue) throws ErrorResultException {
        return this.connection.compare(name, attributeDescription, assertionValue);
    }

    @Override
    public FutureResult<CompareResult> compareAsync(CompareRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super CompareResult> resultHandler) {
        return this.connection.compareAsync(request, intermediateResponseHandler, resultHandler);
    }

    @Override
    public Result delete(DeleteRequest request) throws ErrorResultException {
        return this.connection.delete(request);
    }

    @Override
    public Result delete(String name) throws ErrorResultException {
        return this.connection.delete(name);
    }

    @Override
    public FutureResult<Result> deleteAsync(DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
        return this.connection.deleteAsync(request, intermediateResponseHandler, resultHandler);
    }

    @Override
    public Result deleteSubtree(String name) throws ErrorResultException {
        return this.connection.deleteSubtree(name);
    }

    @Override
    public <R extends ExtendedResult> R extendedRequest(ExtendedRequest<R> request) throws ErrorResultException {
        return this.connection.extendedRequest(request);
    }

    @Override
    public <R extends ExtendedResult> R extendedRequest(ExtendedRequest<R> request, IntermediateResponseHandler handler) throws ErrorResultException {
        return this.connection.extendedRequest(request, handler);
    }

    @Override
    public GenericExtendedResult extendedRequest(String requestName, ByteString requestValue) throws ErrorResultException {
        return this.connection.extendedRequest(requestName, requestValue);
    }

    @Override
    public <R extends ExtendedResult> FutureResult<R> extendedRequestAsync(ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super R> resultHandler) {
        return this.connection.extendedRequestAsync(request, intermediateResponseHandler, resultHandler);
    }

    @Override
    public boolean isClosed() {
        return this.connection.isClosed();
    }

    @Override
    public boolean isValid() {
        return this.connection.isValid();
    }

    @Override
    public Result modify(ModifyRequest request) throws ErrorResultException {
        return this.connection.modify(request);
    }

    @Override
    public Result modify(String ... ldifLines) throws ErrorResultException {
        return this.connection.modify(ldifLines);
    }

    @Override
    public FutureResult<Result> modifyAsync(ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
        return this.connection.modifyAsync(request, intermediateResponseHandler, resultHandler);
    }

    @Override
    public Result modifyDN(ModifyDNRequest request) throws ErrorResultException {
        return this.connection.modifyDN(request);
    }

    @Override
    public Result modifyDN(String name, String newRDN) throws ErrorResultException {
        return this.connection.modifyDN(name, newRDN);
    }

    @Override
    public FutureResult<Result> modifyDNAsync(ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
        return this.connection.modifyDNAsync(request, intermediateResponseHandler, resultHandler);
    }

    @Override
    public SearchResultEntry readEntry(DN name, String ... attributeDescriptions) throws ErrorResultException {
        return this.connection.readEntry(name, attributeDescriptions);
    }

    @Override
    public SearchResultEntry readEntry(String name, String ... attributeDescriptions) throws ErrorResultException {
        return this.connection.readEntry(name, attributeDescriptions);
    }

    @Override
    public FutureResult<SearchResultEntry> readEntryAsync(DN name, Collection<String> attributeDescriptions, ResultHandler<? super SearchResultEntry> handler) {
        return this.connection.readEntryAsync(name, attributeDescriptions, handler);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.connection.removeConnectionEventListener(listener);
    }

    @Override
    public ConnectionEntryReader search(SearchRequest request) {
        return this.connection.search(request);
    }

    @Override
    public Result search(SearchRequest request, Collection<? super SearchResultEntry> entries) throws ErrorResultException {
        return this.connection.search(request, entries);
    }

    @Override
    public Result search(SearchRequest request, Collection<? super SearchResultEntry> entries, Collection<? super SearchResultReference> references) throws ErrorResultException {
        return this.connection.search(request, entries, references);
    }

    @Override
    public Result search(SearchRequest request, SearchResultHandler handler) throws ErrorResultException {
        return this.connection.search(request, handler);
    }

    @Override
    public ConnectionEntryReader search(String baseObject, SearchScope scope, String filter, String ... attributeDescriptions) {
        return this.connection.search(baseObject, scope, filter, attributeDescriptions);
    }

    @Override
    public FutureResult<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler resultHandler) {
        return this.connection.searchAsync(request, intermediateResponseHandler, resultHandler);
    }

    @Override
    public SearchResultEntry searchSingleEntry(SearchRequest request) throws ErrorResultException {
        return this.connection.searchSingleEntry(request);
    }

    @Override
    public SearchResultEntry searchSingleEntry(String baseObject, SearchScope scope, String filter, String ... attributeDescriptions) throws ErrorResultException {
        return this.connection.searchSingleEntry(baseObject, scope, filter, attributeDescriptions);
    }

    @Override
    public FutureResult<SearchResultEntry> searchSingleEntryAsync(SearchRequest request, ResultHandler<? super SearchResultEntry> handler) {
        return this.connection.searchSingleEntryAsync(request, handler);
    }

    public String toString() {
        return this.connection.toString();
    }
}

