/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.Validator;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.AttributeParser;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.MatchingRule;

public abstract class AbstractAttribute
extends AbstractSet<ByteString>
implements Attribute {
    static boolean equals(Attribute attribute, Object object) {
        if (attribute == object) {
            return true;
        }
        if (!(object instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)object;
        if (!attribute.getAttributeDescription().equals(other.getAttributeDescription())) {
            return false;
        }
        if (attribute.size() != other.size()) {
            return false;
        }
        return attribute.containsAll(other);
    }

    static int hashCode(Attribute attribute) {
        int hashCode = attribute.getAttributeDescription().hashCode();
        for (ByteString value : attribute) {
            hashCode += AbstractAttribute.normalizeValue(attribute, value).hashCode();
        }
        return hashCode;
    }

    static ByteString normalizeValue(Attribute attribute, ByteString value) {
        AttributeDescription attributeDescription = attribute.getAttributeDescription();
        AttributeType attributeType = attributeDescription.getAttributeType();
        MatchingRule matchingRule = attributeType.getEqualityMatchingRule();
        try {
            return matchingRule.normalizeAttributeValue(value);
        }
        catch (Exception e) {
            return value;
        }
    }

    static String toString(Attribute attribute) {
        StringBuilder builder = new StringBuilder();
        builder.append('\"');
        builder.append(attribute.getAttributeDescriptionAsString());
        builder.append("\":[");
        boolean firstValue = true;
        for (ByteString value : attribute) {
            if (!firstValue) {
                builder.append(',');
            }
            builder.append('\"');
            builder.append(value);
            builder.append('\"');
            firstValue = false;
        }
        builder.append(']');
        return builder.toString();
    }

    protected AbstractAttribute() {
    }

    @Override
    public abstract boolean add(ByteString var1);

    @Override
    public boolean add(Object ... values) {
        Validator.ensureNotNull(values);
        boolean modified = false;
        for (Object value : values) {
            modified |= this.add(ByteString.valueOf(value));
        }
        return modified;
    }

    @Override
    public boolean addAll(Collection<? extends ByteString> values) {
        return this.addAll(values, null);
    }

    @Override
    public <T> boolean addAll(Collection<T> values, Collection<? super T> duplicateValues) {
        boolean modified = false;
        for (T value : values) {
            if (this.add(new Object[]{value})) {
                modified = true;
                continue;
            }
            if (duplicateValues == null) continue;
            duplicateValues.add(value);
        }
        return modified;
    }

    @Override
    public abstract boolean contains(Object var1);

    @Override
    public boolean containsAll(Collection<?> values) {
        for (Object value : values) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        return AbstractAttribute.equals(this, object);
    }

    @Override
    public ByteString firstValue() {
        return this.iterator().next();
    }

    @Override
    public String firstValueAsString() {
        return this.firstValue().toString();
    }

    @Override
    public abstract AttributeDescription getAttributeDescription();

    @Override
    public String getAttributeDescriptionAsString() {
        return this.getAttributeDescription().toString();
    }

    @Override
    public int hashCode() {
        return AbstractAttribute.hashCode(this);
    }

    @Override
    public AttributeParser parse() {
        return AttributeParser.parseAttribute(this);
    }

    @Override
    public abstract Iterator<ByteString> iterator();

    @Override
    public abstract boolean remove(Object var1);

    @Override
    public boolean removeAll(Collection<?> values) {
        return this.removeAll(values, null);
    }

    @Override
    public <T> boolean removeAll(Collection<T> values, Collection<? super T> missingValues) {
        boolean modified = false;
        for (T value : values) {
            if (this.remove(value)) {
                modified = true;
                continue;
            }
            if (missingValues == null) continue;
            missingValues.add(value);
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> values) {
        return this.retainAll(values, null);
    }

    @Override
    public <T> boolean retainAll(Collection<T> values, Collection<? super T> missingValues) {
        if (values.isEmpty()) {
            if (this.isEmpty()) {
                return false;
            }
            this.clear();
            return true;
        }
        if (this.isEmpty()) {
            if (missingValues != null) {
                for (T value : values) {
                    missingValues.add(value);
                }
            }
            return false;
        }
        HashMap<ByteString, T> valuesToRetain = new HashMap<ByteString, T>(values.size());
        for (T value : values) {
            valuesToRetain.put(AbstractAttribute.normalizeValue(this, ByteString.valueOf(value)), value);
        }
        boolean modified = false;
        Iterator<ByteString> iterator = this.iterator();
        while (iterator.hasNext()) {
            ByteString value = iterator.next();
            ByteString normalizedValue = AbstractAttribute.normalizeValue(this, value);
            if (valuesToRetain.remove(normalizedValue) != null) continue;
            modified = true;
            iterator.remove();
        }
        if (missingValues != null) {
            missingValues.addAll(valuesToRetain.values());
        }
        return modified;
    }

    @Override
    public abstract int size();

    @Override
    public ByteString[] toArray() {
        return this.toArray(new ByteString[this.size()]);
    }

    @Override
    public String toString() {
        return AbstractAttribute.toString(this);
    }
}

