/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import org.forgerock.opendj.ldap.AbstractConnection;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;

public abstract class AbstractAsynchronousConnection
extends AbstractConnection {
    protected AbstractAsynchronousConnection() {
    }

    @Override
    public Result add(AddRequest request) throws ErrorResultException {
        FutureResult<Result> future = this.addAsync(request, null, null);
        try {
            Result result = future.get();
            return result;
        }
        catch (InterruptedException e) {
            throw this.interrupted(e);
        }
        finally {
            future.cancel(false);
        }
    }

    @Override
    public BindResult bind(BindRequest request) throws ErrorResultException {
        FutureResult<BindResult> future = this.bindAsync(request, null, null);
        try {
            BindResult bindResult = future.get();
            return bindResult;
        }
        catch (InterruptedException e) {
            throw this.interrupted(e);
        }
        finally {
            future.cancel(false);
        }
    }

    @Override
    public CompareResult compare(CompareRequest request) throws ErrorResultException {
        FutureResult<CompareResult> future = this.compareAsync(request, null, null);
        try {
            CompareResult compareResult = future.get();
            return compareResult;
        }
        catch (InterruptedException e) {
            throw this.interrupted(e);
        }
        finally {
            future.cancel(false);
        }
    }

    @Override
    public Result delete(DeleteRequest request) throws ErrorResultException {
        FutureResult<Result> future = this.deleteAsync(request, null, null);
        try {
            Result result = future.get();
            return result;
        }
        catch (InterruptedException e) {
            throw this.interrupted(e);
        }
        finally {
            future.cancel(false);
        }
    }

    @Override
    public <R extends ExtendedResult> R extendedRequest(ExtendedRequest<R> request, IntermediateResponseHandler handler) throws ErrorResultException {
        FutureResult<R> future = this.extendedRequestAsync(request, handler, null);
        try {
            ExtendedResult extendedResult = (ExtendedResult)future.get();
            return (R)extendedResult;
        }
        catch (InterruptedException e) {
            throw this.interrupted(e);
        }
        finally {
            future.cancel(false);
        }
    }

    @Override
    public Result modify(ModifyRequest request) throws ErrorResultException {
        FutureResult<Result> future = this.modifyAsync(request, null, null);
        try {
            Result result = future.get();
            return result;
        }
        catch (InterruptedException e) {
            throw this.interrupted(e);
        }
        finally {
            future.cancel(false);
        }
    }

    @Override
    public Result modifyDN(ModifyDNRequest request) throws ErrorResultException {
        FutureResult<Result> future = this.modifyDNAsync(request, null, null);
        try {
            Result result = future.get();
            return result;
        }
        catch (InterruptedException e) {
            throw this.interrupted(e);
        }
        finally {
            future.cancel(false);
        }
    }

    @Override
    public Result search(SearchRequest request, SearchResultHandler handler) throws ErrorResultException {
        FutureResult<Result> future = this.searchAsync(request, null, handler);
        try {
            Result result = future.get();
            return result;
        }
        catch (InterruptedException e) {
            throw this.interrupted(e);
        }
        finally {
            future.cancel(false);
        }
    }

    private ErrorResultException interrupted(InterruptedException e) {
        return ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_USER_CANCELLED, e);
    }
}

