/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.asn1;

import com.forgerock.opendj.util.ByteSequenceOutputStream;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.asn1.ASN1Writer;
import org.forgerock.opendj.asn1.AbstractASN1Writer;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.CoreMessages;

final class ASN1OutputStreamWriter
extends AbstractASN1Writer
implements ASN1Writer {
    private final OutputStream rootStream;
    private OutputStream out;
    private final ArrayList<ByteSequenceOutputStream> streamStack;
    private int stackDepth;

    ASN1OutputStreamWriter(OutputStream stream) {
        this.out = stream;
        this.rootStream = stream;
        this.streamStack = new ArrayList();
        this.stackDepth = -1;
    }

    @Override
    public void close() throws IOException {
        while (this.stackDepth >= 0) {
            this.writeEndSequence();
        }
        this.rootStream.flush();
        this.streamStack.clear();
        this.rootStream.close();
    }

    @Override
    public void flush() throws IOException {
        this.rootStream.flush();
    }

    @Override
    public ASN1Writer writeBoolean(byte type, boolean booleanValue) throws IOException {
        this.out.write(type);
        this.writeLength(1);
        this.out.write(booleanValue ? -1 : 0);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
            StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 BOOLEAN(type=0x%x, length=%d, value=%s)", type, 1, String.valueOf(booleanValue)));
        }
        return this;
    }

    @Override
    public ASN1Writer writeEndSequence() throws IOException {
        OutputStream parentStream;
        if (this.stackDepth < 0) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_SEQUENCE_WRITE_NOT_STARTED.get();
            throw new IllegalStateException(message.toString());
        }
        ByteSequenceOutputStream childStream = this.streamStack.get(this.stackDepth);
        --this.stackDepth;
        this.out = parentStream = this.stackDepth < 0 ? this.rootStream : (OutputStream)this.streamStack.get(this.stackDepth);
        this.writeLength(childStream.length());
        childStream.writeTo(parentStream);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
            StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 END SEQUENCE(length=%d)", childStream.length()));
        }
        childStream.reset();
        return this;
    }

    @Override
    public ASN1Writer writeEndSet() throws IOException {
        return this.writeEndSequence();
    }

    @Override
    public ASN1Writer writeEnumerated(byte type, int intValue) throws IOException {
        return this.writeInteger(type, intValue);
    }

    @Override
    public ASN1Writer writeInteger(byte type, int intValue) throws IOException {
        this.out.write(type);
        if (intValue < 0 && (intValue & 0xFFFFFF80) == -128 || (intValue & 0x7F) == intValue) {
            this.writeLength(1);
            this.out.write((byte)(intValue & 0xFF));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 1, intValue));
            }
        } else if (intValue < 0 && (intValue & Short.MIN_VALUE) == Short.MIN_VALUE || (intValue & Short.MAX_VALUE) == intValue) {
            this.writeLength(2);
            this.out.write((byte)(intValue >> 8 & 0xFF));
            this.out.write((byte)(intValue & 0xFF));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 2, intValue));
            }
        } else if (intValue < 0 && (intValue & 0xFF800000) == -8388608 || (intValue & 0x7FFFFF) == intValue) {
            this.writeLength(3);
            this.out.write((byte)(intValue >> 16 & 0xFF));
            this.out.write((byte)(intValue >> 8 & 0xFF));
            this.out.write((byte)(intValue & 0xFF));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 3, intValue));
            }
        } else {
            this.writeLength(4);
            this.out.write((byte)(intValue >> 24 & 0xFF));
            this.out.write((byte)(intValue >> 16 & 0xFF));
            this.out.write((byte)(intValue >> 8 & 0xFF));
            this.out.write((byte)(intValue & 0xFF));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 4, intValue));
            }
        }
        return this;
    }

    @Override
    public ASN1Writer writeInteger(byte type, long longValue) throws IOException {
        this.out.write(type);
        if (longValue < 0L && (longValue & 0xFFFFFFFFFFFFFF80L) == -128L || (longValue & 0x7FL) == longValue) {
            this.writeLength(1);
            this.out.write((byte)(longValue & 0xFFL));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 1, longValue));
            }
        } else if (longValue < 0L && (longValue & 0xFFFFFFFFFFFF8000L) == -32768L || (longValue & 0x7FFFL) == longValue) {
            this.writeLength(2);
            this.out.write((byte)(longValue >> 8 & 0xFFL));
            this.out.write((byte)(longValue & 0xFFL));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 2, longValue));
            }
        } else if (longValue < 0L && (longValue & 0xFFFFFFFFFF800000L) == -8388608L || (longValue & 0x7FFFFFL) == longValue) {
            this.writeLength(3);
            this.out.write((byte)(longValue >> 16 & 0xFFL));
            this.out.write((byte)(longValue >> 8 & 0xFFL));
            this.out.write((byte)(longValue & 0xFFL));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 3, longValue));
            }
        } else if (longValue < 0L && (longValue & Integer.MIN_VALUE) == Integer.MIN_VALUE || (longValue & Integer.MAX_VALUE) == longValue) {
            this.writeLength(4);
            this.out.write((byte)(longValue >> 24 & 0xFFL));
            this.out.write((byte)(longValue >> 16 & 0xFFL));
            this.out.write((byte)(longValue >> 8 & 0xFFL));
            this.out.write((byte)(longValue & 0xFFL));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 4, longValue));
            }
        } else if (longValue < 0L && (longValue & 0xFFFFFF8000000000L) == -549755813888L || (longValue & 0x7FFFFFFFFFL) == longValue) {
            this.writeLength(5);
            this.out.write((byte)(longValue >> 32 & 0xFFL));
            this.out.write((byte)(longValue >> 24 & 0xFFL));
            this.out.write((byte)(longValue >> 16 & 0xFFL));
            this.out.write((byte)(longValue >> 8 & 0xFFL));
            this.out.write((byte)(longValue & 0xFFL));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 5, longValue));
            }
        } else if (longValue < 0L && (longValue & 0xFFFF800000000000L) == -140737488355328L || (longValue & 0x7FFFFFFFFFFFL) == longValue) {
            this.writeLength(6);
            this.out.write((byte)(longValue >> 40 & 0xFFL));
            this.out.write((byte)(longValue >> 32 & 0xFFL));
            this.out.write((byte)(longValue >> 24 & 0xFFL));
            this.out.write((byte)(longValue >> 16 & 0xFFL));
            this.out.write((byte)(longValue >> 8 & 0xFFL));
            this.out.write((byte)(longValue & 0xFFL));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 6, longValue));
            }
        } else if (longValue < 0L && (longValue & 0xFF80000000000000L) == -36028797018963968L || (longValue & 0x7FFFFFFFFFFFFFL) == longValue) {
            this.writeLength(7);
            this.out.write((byte)(longValue >> 48 & 0xFFL));
            this.out.write((byte)(longValue >> 40 & 0xFFL));
            this.out.write((byte)(longValue >> 32 & 0xFFL));
            this.out.write((byte)(longValue >> 24 & 0xFFL));
            this.out.write((byte)(longValue >> 16 & 0xFFL));
            this.out.write((byte)(longValue >> 8 & 0xFFL));
            this.out.write((byte)(longValue & 0xFFL));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 7, longValue));
            }
        } else {
            this.writeLength(8);
            this.out.write((byte)(longValue >> 56 & 0xFFL));
            this.out.write((byte)(longValue >> 48 & 0xFFL));
            this.out.write((byte)(longValue >> 40 & 0xFFL));
            this.out.write((byte)(longValue >> 32 & 0xFFL));
            this.out.write((byte)(longValue >> 24 & 0xFFL));
            this.out.write((byte)(longValue >> 16 & 0xFFL));
            this.out.write((byte)(longValue >> 8 & 0xFFL));
            this.out.write((byte)(longValue & 0xFFL));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 8, longValue));
            }
        }
        return this;
    }

    @Override
    public ASN1Writer writeNull(byte type) throws IOException {
        this.out.write(type);
        this.writeLength(0);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
            StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 NULL(type=0x%x, length=%d)", type, 0));
        }
        return this;
    }

    @Override
    public ASN1Writer writeOctetString(byte type, byte[] value, int offset, int length) throws IOException {
        this.out.write(type);
        this.writeLength(length);
        this.out.write(value, offset, length);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
            StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 OCTETSTRING(type=0x%x, length=%d)", type, length));
        }
        return this;
    }

    @Override
    public ASN1Writer writeOctetString(byte type, ByteSequence value) throws IOException {
        this.out.write(type);
        this.writeLength(value.length());
        value.copyTo(this.out);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
            StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 OCTETSTRING(type=0x%x, length=%d)", type, value.length()));
        }
        return this;
    }

    @Override
    public ASN1Writer writeOctetString(byte type, String value) throws IOException {
        this.out.write(type);
        if (value == null) {
            this.writeLength(0);
            return this;
        }
        byte[] bytes = StaticUtils.getBytes(value);
        this.writeLength(bytes.length);
        this.out.write(bytes);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
            StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 OCTETSTRING(type=0x%x, length=%d, value=%s)", type, bytes.length, value));
        }
        return this;
    }

    @Override
    public ASN1Writer writeStartSequence(byte type) throws IOException {
        this.out.write(type);
        ++this.stackDepth;
        if (this.stackDepth >= this.streamStack.size()) {
            ByteSequenceOutputStream subStream = new ByteSequenceOutputStream(new ByteStringBuilder());
            this.streamStack.add(subStream);
            this.out = subStream;
        } else {
            this.out = this.streamStack.get(this.stackDepth);
        }
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
            StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 START SEQUENCE(type=0x%x)", type));
        }
        return this;
    }

    @Override
    public ASN1Writer writeStartSet(byte type) throws IOException {
        return this.writeStartSequence(type);
    }

    private void writeLength(int length) throws IOException {
        if (length < 128) {
            this.out.write((byte)length);
        } else if ((length & 0xFF) == length) {
            this.out.write(-127);
            this.out.write((byte)(length & 0xFF));
        } else if ((length & 0xFFFF) == length) {
            this.out.write(-126);
            this.out.write((byte)(length >> 8 & 0xFF));
            this.out.write((byte)(length & 0xFF));
        } else if ((length & 0xFFFFFF) == length) {
            this.out.write(-125);
            this.out.write((byte)(length >> 16 & 0xFF));
            this.out.write((byte)(length >> 8 & 0xFF));
            this.out.write((byte)(length & 0xFF));
        } else {
            this.out.write(-124);
            this.out.write((byte)(length >> 24 & 0xFF));
            this.out.write((byte)(length >> 16 & 0xFF));
            this.out.write((byte)(length >> 8 & 0xFF));
            this.out.write((byte)(length & 0xFF));
        }
    }
}

