/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.asn1;

import com.forgerock.opendj.util.ByteSequenceOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.forgerock.opendj.asn1.ASN1ByteSequenceReader;
import org.forgerock.opendj.asn1.ASN1InputStreamReader;
import org.forgerock.opendj.asn1.ASN1OutputStreamWriter;
import org.forgerock.opendj.asn1.ASN1Reader;
import org.forgerock.opendj.asn1.ASN1Writer;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteSequenceReader;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;

public final class ASN1 {
    public static final byte BOOLEAN_VALUE_FALSE = 0;
    public static final byte BOOLEAN_VALUE_TRUE = -1;
    public static final byte UNIVERSAL_BOOLEAN_TYPE = 1;
    public static final byte UNIVERSAL_ENUMERATED_TYPE = 10;
    public static final byte UNIVERSAL_INTEGER_TYPE = 2;
    public static final byte UNIVERSAL_NULL_TYPE = 5;
    public static final byte UNIVERSAL_OCTET_STRING_TYPE = 4;
    public static final byte UNIVERSAL_SEQUENCE_TYPE = 48;
    public static final byte UNIVERSAL_SET_TYPE = 49;
    static final int ELEMENT_READ_STATE_NEED_ADDITIONAL_LENGTH_BYTES = 2;
    static final int ELEMENT_READ_STATE_NEED_FIRST_LENGTH_BYTE = 1;
    static final int ELEMENT_READ_STATE_NEED_TYPE = 0;
    static final int ELEMENT_READ_STATE_NEED_VALUE_BYTES = 3;
    static final byte[] NO_VALUE = new byte[0];
    static final byte TYPE_MASK_ALL_BUT_CLASS = -64;
    static final byte TYPE_MASK_ALL_BUT_PC = 32;
    static final byte TYPE_MASK_APPLICATION = 64;
    static final byte TYPE_MASK_CONSTRUCTED = 32;
    static final byte TYPE_MASK_CONTEXT = -128;
    static final byte TYPE_MASK_PRIMITIVE = 0;
    static final byte TYPE_MASK_PRIVATE = -64;
    static final byte TYPE_MASK_UNIVERSAL = 0;

    public static ASN1Reader getReader(byte[] array) {
        return ASN1.getReader(array, 0);
    }

    public static ASN1Reader getReader(byte[] array, int maxElementSize) {
        return ASN1.getReader(ByteString.wrap(array), maxElementSize);
    }

    public static ASN1Reader getReader(ByteSequence sequence) {
        return ASN1.getReader(sequence, 0);
    }

    public static ASN1Reader getReader(ByteSequence sequence, int maxElementSize) {
        return new ASN1ByteSequenceReader(sequence.asReader(), maxElementSize);
    }

    public static ASN1Reader getReader(ByteSequenceReader reader) {
        return ASN1.getReader(reader, 0);
    }

    public static ASN1Reader getReader(ByteSequenceReader reader, int maxElementSize) {
        return new ASN1ByteSequenceReader(reader, maxElementSize);
    }

    public static ASN1Reader getReader(InputStream stream) {
        return ASN1.getReader(stream, 0);
    }

    public static ASN1Reader getReader(InputStream stream, int maxElementSize) {
        return new ASN1InputStreamReader(stream, maxElementSize);
    }

    public static ASN1Writer getWriter(ByteStringBuilder builder) {
        ByteSequenceOutputStream outputStream = new ByteSequenceOutputStream(builder);
        return ASN1.getWriter(outputStream);
    }

    public static ASN1Writer getWriter(OutputStream stream) {
        return new ASN1OutputStreamWriter(stream);
    }

    private ASN1() {
    }
}

