/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import com.forgerock.opendj.util.ASCIICharProp;
import com.forgerock.opendj.util.ReferenceCountedObject;
import com.forgerock.opendj.util.Validator;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.forgerock.i18n.LocalizableException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.CoreMessages;

public final class StaticUtils {
    public static final Logger DEBUG_LOG = Logger.getLogger("org.forgerock.opendj.ldap");
    public static final String EOL = System.getProperty("line.separator");
    public static final byte[] EMPTY_BYTES = new byte[0];
    private static final String TIME_ZONE_UTC = "UTC";
    private static final TimeZone TIME_ZONE_UTC_OBJ = TimeZone.getTimeZone("UTC");
    public static final ReferenceCountedObject<ScheduledExecutorService> DEFAULT_SCHEDULER = new ReferenceCountedObject<ScheduledExecutorService>(){

        @Override
        protected ScheduledExecutorService newInstance() {
            ThreadFactory factory = StaticUtils.newThreadFactory(null, "OpenDJ LDAP SDK Default Scheduler", true);
            return Executors.newSingleThreadScheduledExecutor(factory);
        }

        @Override
        protected void destroyInstance(ScheduledExecutorService instance) {
            instance.shutdown();
            try {
                instance.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    };

    public static String byteToHex(byte b) {
        switch (b & 0xFF) {
            case 0: {
                return "00";
            }
            case 1: {
                return "01";
            }
            case 2: {
                return "02";
            }
            case 3: {
                return "03";
            }
            case 4: {
                return "04";
            }
            case 5: {
                return "05";
            }
            case 6: {
                return "06";
            }
            case 7: {
                return "07";
            }
            case 8: {
                return "08";
            }
            case 9: {
                return "09";
            }
            case 10: {
                return "0A";
            }
            case 11: {
                return "0B";
            }
            case 12: {
                return "0C";
            }
            case 13: {
                return "0D";
            }
            case 14: {
                return "0E";
            }
            case 15: {
                return "0F";
            }
            case 16: {
                return "10";
            }
            case 17: {
                return "11";
            }
            case 18: {
                return "12";
            }
            case 19: {
                return "13";
            }
            case 20: {
                return "14";
            }
            case 21: {
                return "15";
            }
            case 22: {
                return "16";
            }
            case 23: {
                return "17";
            }
            case 24: {
                return "18";
            }
            case 25: {
                return "19";
            }
            case 26: {
                return "1A";
            }
            case 27: {
                return "1B";
            }
            case 28: {
                return "1C";
            }
            case 29: {
                return "1D";
            }
            case 30: {
                return "1E";
            }
            case 31: {
                return "1F";
            }
            case 32: {
                return "20";
            }
            case 33: {
                return "21";
            }
            case 34: {
                return "22";
            }
            case 35: {
                return "23";
            }
            case 36: {
                return "24";
            }
            case 37: {
                return "25";
            }
            case 38: {
                return "26";
            }
            case 39: {
                return "27";
            }
            case 40: {
                return "28";
            }
            case 41: {
                return "29";
            }
            case 42: {
                return "2A";
            }
            case 43: {
                return "2B";
            }
            case 44: {
                return "2C";
            }
            case 45: {
                return "2D";
            }
            case 46: {
                return "2E";
            }
            case 47: {
                return "2F";
            }
            case 48: {
                return "30";
            }
            case 49: {
                return "31";
            }
            case 50: {
                return "32";
            }
            case 51: {
                return "33";
            }
            case 52: {
                return "34";
            }
            case 53: {
                return "35";
            }
            case 54: {
                return "36";
            }
            case 55: {
                return "37";
            }
            case 56: {
                return "38";
            }
            case 57: {
                return "39";
            }
            case 58: {
                return "3A";
            }
            case 59: {
                return "3B";
            }
            case 60: {
                return "3C";
            }
            case 61: {
                return "3D";
            }
            case 62: {
                return "3E";
            }
            case 63: {
                return "3F";
            }
            case 64: {
                return "40";
            }
            case 65: {
                return "41";
            }
            case 66: {
                return "42";
            }
            case 67: {
                return "43";
            }
            case 68: {
                return "44";
            }
            case 69: {
                return "45";
            }
            case 70: {
                return "46";
            }
            case 71: {
                return "47";
            }
            case 72: {
                return "48";
            }
            case 73: {
                return "49";
            }
            case 74: {
                return "4A";
            }
            case 75: {
                return "4B";
            }
            case 76: {
                return "4C";
            }
            case 77: {
                return "4D";
            }
            case 78: {
                return "4E";
            }
            case 79: {
                return "4F";
            }
            case 80: {
                return "50";
            }
            case 81: {
                return "51";
            }
            case 82: {
                return "52";
            }
            case 83: {
                return "53";
            }
            case 84: {
                return "54";
            }
            case 85: {
                return "55";
            }
            case 86: {
                return "56";
            }
            case 87: {
                return "57";
            }
            case 88: {
                return "58";
            }
            case 89: {
                return "59";
            }
            case 90: {
                return "5A";
            }
            case 91: {
                return "5B";
            }
            case 92: {
                return "5C";
            }
            case 93: {
                return "5D";
            }
            case 94: {
                return "5E";
            }
            case 95: {
                return "5F";
            }
            case 96: {
                return "60";
            }
            case 97: {
                return "61";
            }
            case 98: {
                return "62";
            }
            case 99: {
                return "63";
            }
            case 100: {
                return "64";
            }
            case 101: {
                return "65";
            }
            case 102: {
                return "66";
            }
            case 103: {
                return "67";
            }
            case 104: {
                return "68";
            }
            case 105: {
                return "69";
            }
            case 106: {
                return "6A";
            }
            case 107: {
                return "6B";
            }
            case 108: {
                return "6C";
            }
            case 109: {
                return "6D";
            }
            case 110: {
                return "6E";
            }
            case 111: {
                return "6F";
            }
            case 112: {
                return "70";
            }
            case 113: {
                return "71";
            }
            case 114: {
                return "72";
            }
            case 115: {
                return "73";
            }
            case 116: {
                return "74";
            }
            case 117: {
                return "75";
            }
            case 118: {
                return "76";
            }
            case 119: {
                return "77";
            }
            case 120: {
                return "78";
            }
            case 121: {
                return "79";
            }
            case 122: {
                return "7A";
            }
            case 123: {
                return "7B";
            }
            case 124: {
                return "7C";
            }
            case 125: {
                return "7D";
            }
            case 126: {
                return "7E";
            }
            case 127: {
                return "7F";
            }
            case 128: {
                return "80";
            }
            case 129: {
                return "81";
            }
            case 130: {
                return "82";
            }
            case 131: {
                return "83";
            }
            case 132: {
                return "84";
            }
            case 133: {
                return "85";
            }
            case 134: {
                return "86";
            }
            case 135: {
                return "87";
            }
            case 136: {
                return "88";
            }
            case 137: {
                return "89";
            }
            case 138: {
                return "8A";
            }
            case 139: {
                return "8B";
            }
            case 140: {
                return "8C";
            }
            case 141: {
                return "8D";
            }
            case 142: {
                return "8E";
            }
            case 143: {
                return "8F";
            }
            case 144: {
                return "90";
            }
            case 145: {
                return "91";
            }
            case 146: {
                return "92";
            }
            case 147: {
                return "93";
            }
            case 148: {
                return "94";
            }
            case 149: {
                return "95";
            }
            case 150: {
                return "96";
            }
            case 151: {
                return "97";
            }
            case 152: {
                return "98";
            }
            case 153: {
                return "99";
            }
            case 154: {
                return "9A";
            }
            case 155: {
                return "9B";
            }
            case 156: {
                return "9C";
            }
            case 157: {
                return "9D";
            }
            case 158: {
                return "9E";
            }
            case 159: {
                return "9F";
            }
            case 160: {
                return "A0";
            }
            case 161: {
                return "A1";
            }
            case 162: {
                return "A2";
            }
            case 163: {
                return "A3";
            }
            case 164: {
                return "A4";
            }
            case 165: {
                return "A5";
            }
            case 166: {
                return "A6";
            }
            case 167: {
                return "A7";
            }
            case 168: {
                return "A8";
            }
            case 169: {
                return "A9";
            }
            case 170: {
                return "AA";
            }
            case 171: {
                return "AB";
            }
            case 172: {
                return "AC";
            }
            case 173: {
                return "AD";
            }
            case 174: {
                return "AE";
            }
            case 175: {
                return "AF";
            }
            case 176: {
                return "B0";
            }
            case 177: {
                return "B1";
            }
            case 178: {
                return "B2";
            }
            case 179: {
                return "B3";
            }
            case 180: {
                return "B4";
            }
            case 181: {
                return "B5";
            }
            case 182: {
                return "B6";
            }
            case 183: {
                return "B7";
            }
            case 184: {
                return "B8";
            }
            case 185: {
                return "B9";
            }
            case 186: {
                return "BA";
            }
            case 187: {
                return "BB";
            }
            case 188: {
                return "BC";
            }
            case 189: {
                return "BD";
            }
            case 190: {
                return "BE";
            }
            case 191: {
                return "BF";
            }
            case 192: {
                return "C0";
            }
            case 193: {
                return "C1";
            }
            case 194: {
                return "C2";
            }
            case 195: {
                return "C3";
            }
            case 196: {
                return "C4";
            }
            case 197: {
                return "C5";
            }
            case 198: {
                return "C6";
            }
            case 199: {
                return "C7";
            }
            case 200: {
                return "C8";
            }
            case 201: {
                return "C9";
            }
            case 202: {
                return "CA";
            }
            case 203: {
                return "CB";
            }
            case 204: {
                return "CC";
            }
            case 205: {
                return "CD";
            }
            case 206: {
                return "CE";
            }
            case 207: {
                return "CF";
            }
            case 208: {
                return "D0";
            }
            case 209: {
                return "D1";
            }
            case 210: {
                return "D2";
            }
            case 211: {
                return "D3";
            }
            case 212: {
                return "D4";
            }
            case 213: {
                return "D5";
            }
            case 214: {
                return "D6";
            }
            case 215: {
                return "D7";
            }
            case 216: {
                return "D8";
            }
            case 217: {
                return "D9";
            }
            case 218: {
                return "DA";
            }
            case 219: {
                return "DB";
            }
            case 220: {
                return "DC";
            }
            case 221: {
                return "DD";
            }
            case 222: {
                return "DE";
            }
            case 223: {
                return "DF";
            }
            case 224: {
                return "E0";
            }
            case 225: {
                return "E1";
            }
            case 226: {
                return "E2";
            }
            case 227: {
                return "E3";
            }
            case 228: {
                return "E4";
            }
            case 229: {
                return "E5";
            }
            case 230: {
                return "E6";
            }
            case 231: {
                return "E7";
            }
            case 232: {
                return "E8";
            }
            case 233: {
                return "E9";
            }
            case 234: {
                return "EA";
            }
            case 235: {
                return "EB";
            }
            case 236: {
                return "EC";
            }
            case 237: {
                return "ED";
            }
            case 238: {
                return "EE";
            }
            case 239: {
                return "EF";
            }
            case 240: {
                return "F0";
            }
            case 241: {
                return "F1";
            }
            case 242: {
                return "F2";
            }
            case 243: {
                return "F3";
            }
            case 244: {
                return "F4";
            }
            case 245: {
                return "F5";
            }
            case 246: {
                return "F6";
            }
            case 247: {
                return "F7";
            }
            case 248: {
                return "F8";
            }
            case 249: {
                return "F9";
            }
            case 250: {
                return "FA";
            }
            case 251: {
                return "FB";
            }
            case 252: {
                return "FC";
            }
            case 253: {
                return "FD";
            }
            case 254: {
                return "FE";
            }
            case 255: {
                return "FF";
            }
        }
        return "??";
    }

    public static String byteToLowerHex(byte b) {
        switch (b & 0xFF) {
            case 0: {
                return "00";
            }
            case 1: {
                return "01";
            }
            case 2: {
                return "02";
            }
            case 3: {
                return "03";
            }
            case 4: {
                return "04";
            }
            case 5: {
                return "05";
            }
            case 6: {
                return "06";
            }
            case 7: {
                return "07";
            }
            case 8: {
                return "08";
            }
            case 9: {
                return "09";
            }
            case 10: {
                return "0a";
            }
            case 11: {
                return "0b";
            }
            case 12: {
                return "0c";
            }
            case 13: {
                return "0d";
            }
            case 14: {
                return "0e";
            }
            case 15: {
                return "0f";
            }
            case 16: {
                return "10";
            }
            case 17: {
                return "11";
            }
            case 18: {
                return "12";
            }
            case 19: {
                return "13";
            }
            case 20: {
                return "14";
            }
            case 21: {
                return "15";
            }
            case 22: {
                return "16";
            }
            case 23: {
                return "17";
            }
            case 24: {
                return "18";
            }
            case 25: {
                return "19";
            }
            case 26: {
                return "1a";
            }
            case 27: {
                return "1b";
            }
            case 28: {
                return "1c";
            }
            case 29: {
                return "1d";
            }
            case 30: {
                return "1e";
            }
            case 31: {
                return "1f";
            }
            case 32: {
                return "20";
            }
            case 33: {
                return "21";
            }
            case 34: {
                return "22";
            }
            case 35: {
                return "23";
            }
            case 36: {
                return "24";
            }
            case 37: {
                return "25";
            }
            case 38: {
                return "26";
            }
            case 39: {
                return "27";
            }
            case 40: {
                return "28";
            }
            case 41: {
                return "29";
            }
            case 42: {
                return "2a";
            }
            case 43: {
                return "2b";
            }
            case 44: {
                return "2c";
            }
            case 45: {
                return "2d";
            }
            case 46: {
                return "2e";
            }
            case 47: {
                return "2f";
            }
            case 48: {
                return "30";
            }
            case 49: {
                return "31";
            }
            case 50: {
                return "32";
            }
            case 51: {
                return "33";
            }
            case 52: {
                return "34";
            }
            case 53: {
                return "35";
            }
            case 54: {
                return "36";
            }
            case 55: {
                return "37";
            }
            case 56: {
                return "38";
            }
            case 57: {
                return "39";
            }
            case 58: {
                return "3a";
            }
            case 59: {
                return "3b";
            }
            case 60: {
                return "3c";
            }
            case 61: {
                return "3d";
            }
            case 62: {
                return "3e";
            }
            case 63: {
                return "3f";
            }
            case 64: {
                return "40";
            }
            case 65: {
                return "41";
            }
            case 66: {
                return "42";
            }
            case 67: {
                return "43";
            }
            case 68: {
                return "44";
            }
            case 69: {
                return "45";
            }
            case 70: {
                return "46";
            }
            case 71: {
                return "47";
            }
            case 72: {
                return "48";
            }
            case 73: {
                return "49";
            }
            case 74: {
                return "4a";
            }
            case 75: {
                return "4b";
            }
            case 76: {
                return "4c";
            }
            case 77: {
                return "4d";
            }
            case 78: {
                return "4e";
            }
            case 79: {
                return "4f";
            }
            case 80: {
                return "50";
            }
            case 81: {
                return "51";
            }
            case 82: {
                return "52";
            }
            case 83: {
                return "53";
            }
            case 84: {
                return "54";
            }
            case 85: {
                return "55";
            }
            case 86: {
                return "56";
            }
            case 87: {
                return "57";
            }
            case 88: {
                return "58";
            }
            case 89: {
                return "59";
            }
            case 90: {
                return "5a";
            }
            case 91: {
                return "5b";
            }
            case 92: {
                return "5c";
            }
            case 93: {
                return "5d";
            }
            case 94: {
                return "5e";
            }
            case 95: {
                return "5f";
            }
            case 96: {
                return "60";
            }
            case 97: {
                return "61";
            }
            case 98: {
                return "62";
            }
            case 99: {
                return "63";
            }
            case 100: {
                return "64";
            }
            case 101: {
                return "65";
            }
            case 102: {
                return "66";
            }
            case 103: {
                return "67";
            }
            case 104: {
                return "68";
            }
            case 105: {
                return "69";
            }
            case 106: {
                return "6a";
            }
            case 107: {
                return "6b";
            }
            case 108: {
                return "6c";
            }
            case 109: {
                return "6d";
            }
            case 110: {
                return "6e";
            }
            case 111: {
                return "6f";
            }
            case 112: {
                return "70";
            }
            case 113: {
                return "71";
            }
            case 114: {
                return "72";
            }
            case 115: {
                return "73";
            }
            case 116: {
                return "74";
            }
            case 117: {
                return "75";
            }
            case 118: {
                return "76";
            }
            case 119: {
                return "77";
            }
            case 120: {
                return "78";
            }
            case 121: {
                return "79";
            }
            case 122: {
                return "7a";
            }
            case 123: {
                return "7b";
            }
            case 124: {
                return "7c";
            }
            case 125: {
                return "7d";
            }
            case 126: {
                return "7e";
            }
            case 127: {
                return "7f";
            }
            case 128: {
                return "80";
            }
            case 129: {
                return "81";
            }
            case 130: {
                return "82";
            }
            case 131: {
                return "83";
            }
            case 132: {
                return "84";
            }
            case 133: {
                return "85";
            }
            case 134: {
                return "86";
            }
            case 135: {
                return "87";
            }
            case 136: {
                return "88";
            }
            case 137: {
                return "89";
            }
            case 138: {
                return "8a";
            }
            case 139: {
                return "8b";
            }
            case 140: {
                return "8c";
            }
            case 141: {
                return "8d";
            }
            case 142: {
                return "8e";
            }
            case 143: {
                return "8f";
            }
            case 144: {
                return "90";
            }
            case 145: {
                return "91";
            }
            case 146: {
                return "92";
            }
            case 147: {
                return "93";
            }
            case 148: {
                return "94";
            }
            case 149: {
                return "95";
            }
            case 150: {
                return "96";
            }
            case 151: {
                return "97";
            }
            case 152: {
                return "98";
            }
            case 153: {
                return "99";
            }
            case 154: {
                return "9a";
            }
            case 155: {
                return "9b";
            }
            case 156: {
                return "9c";
            }
            case 157: {
                return "9d";
            }
            case 158: {
                return "9e";
            }
            case 159: {
                return "9f";
            }
            case 160: {
                return "a0";
            }
            case 161: {
                return "a1";
            }
            case 162: {
                return "a2";
            }
            case 163: {
                return "a3";
            }
            case 164: {
                return "a4";
            }
            case 165: {
                return "a5";
            }
            case 166: {
                return "a6";
            }
            case 167: {
                return "a7";
            }
            case 168: {
                return "a8";
            }
            case 169: {
                return "a9";
            }
            case 170: {
                return "aa";
            }
            case 171: {
                return "ab";
            }
            case 172: {
                return "ac";
            }
            case 173: {
                return "ad";
            }
            case 174: {
                return "ae";
            }
            case 175: {
                return "af";
            }
            case 176: {
                return "b0";
            }
            case 177: {
                return "b1";
            }
            case 178: {
                return "b2";
            }
            case 179: {
                return "b3";
            }
            case 180: {
                return "b4";
            }
            case 181: {
                return "b5";
            }
            case 182: {
                return "b6";
            }
            case 183: {
                return "b7";
            }
            case 184: {
                return "b8";
            }
            case 185: {
                return "b9";
            }
            case 186: {
                return "ba";
            }
            case 187: {
                return "bb";
            }
            case 188: {
                return "bc";
            }
            case 189: {
                return "bd";
            }
            case 190: {
                return "be";
            }
            case 191: {
                return "bf";
            }
            case 192: {
                return "c0";
            }
            case 193: {
                return "c1";
            }
            case 194: {
                return "c2";
            }
            case 195: {
                return "c3";
            }
            case 196: {
                return "c4";
            }
            case 197: {
                return "c5";
            }
            case 198: {
                return "c6";
            }
            case 199: {
                return "c7";
            }
            case 200: {
                return "c8";
            }
            case 201: {
                return "c9";
            }
            case 202: {
                return "ca";
            }
            case 203: {
                return "cb";
            }
            case 204: {
                return "cc";
            }
            case 205: {
                return "cd";
            }
            case 206: {
                return "ce";
            }
            case 207: {
                return "cf";
            }
            case 208: {
                return "d0";
            }
            case 209: {
                return "d1";
            }
            case 210: {
                return "d2";
            }
            case 211: {
                return "d3";
            }
            case 212: {
                return "d4";
            }
            case 213: {
                return "d5";
            }
            case 214: {
                return "d6";
            }
            case 215: {
                return "d7";
            }
            case 216: {
                return "d8";
            }
            case 217: {
                return "d9";
            }
            case 218: {
                return "da";
            }
            case 219: {
                return "db";
            }
            case 220: {
                return "dc";
            }
            case 221: {
                return "dd";
            }
            case 222: {
                return "de";
            }
            case 223: {
                return "df";
            }
            case 224: {
                return "e0";
            }
            case 225: {
                return "e1";
            }
            case 226: {
                return "e2";
            }
            case 227: {
                return "e3";
            }
            case 228: {
                return "e4";
            }
            case 229: {
                return "e5";
            }
            case 230: {
                return "e6";
            }
            case 231: {
                return "e7";
            }
            case 232: {
                return "e8";
            }
            case 233: {
                return "e9";
            }
            case 234: {
                return "ea";
            }
            case 235: {
                return "eb";
            }
            case 236: {
                return "ec";
            }
            case 237: {
                return "ed";
            }
            case 238: {
                return "ee";
            }
            case 239: {
                return "ef";
            }
            case 240: {
                return "f0";
            }
            case 241: {
                return "f1";
            }
            case 242: {
                return "f2";
            }
            case 243: {
                return "f3";
            }
            case 244: {
                return "f4";
            }
            case 245: {
                return "f5";
            }
            case 246: {
                return "f6";
            }
            case 247: {
                return "f7";
            }
            case 248: {
                return "f8";
            }
            case 249: {
                return "f9";
            }
            case 250: {
                return "fa";
            }
            case 251: {
                return "fb";
            }
            case 252: {
                return "fc";
            }
            case 253: {
                return "fd";
            }
            case 254: {
                return "fe";
            }
            case 255: {
                return "ff";
            }
        }
        return "??";
    }

    public static void closeSilently(Closeable ... resources) {
        for (Closeable r : resources) {
            try {
                if (r == null) continue;
                r.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int compress(byte[] src, int srcOff, int srcLen, byte[] dst, int dstOff, int dstLen) {
        Deflater deflater = new Deflater();
        try {
            deflater.setInput(src, srcOff, srcLen);
            deflater.finish();
            int compressedLength = deflater.deflate(dst, dstOff, dstLen);
            if (deflater.finished()) {
                int n = compressedLength;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            deflater.end();
        }
    }

    public static boolean compress(ByteSequence input, ByteStringBuilder output) {
        byte[] outputBytes;
        byte[] inputBytes = input.toByteArray();
        int compressedSize = StaticUtils.compress(inputBytes, 0, inputBytes.length, outputBytes = new byte[inputBytes.length], 0, outputBytes.length);
        if (compressedSize != -1) {
            if (DEBUG_LOG.isLoggable(Level.FINE)) {
                DEBUG_LOG.fine(String.format("Compression %d/%d%n", compressedSize, inputBytes.length));
            }
            output.append(outputBytes, 0, compressedSize);
            return true;
        }
        return false;
    }

    public static String formatAsGeneralizedTime(Date date) {
        return StaticUtils.formatAsGeneralizedTime(date.getTime());
    }

    public static String formatAsGeneralizedTime(long date) {
        StringBuilder sb = new StringBuilder(19);
        GregorianCalendar calendar = new GregorianCalendar(TIME_ZONE_UTC_OBJ);
        calendar.setLenient(false);
        calendar.setTimeInMillis(date);
        int n = calendar.get(1);
        if (n < 0) {
            IllegalArgumentException e = new IllegalArgumentException("Year cannot be < 0:" + n);
            DEBUG_LOG.throwing("GeneralizedTimeSyntax", "format", e);
            throw e;
        }
        if (n < 10) {
            sb.append("000");
        } else if (n < 100) {
            sb.append("00");
        } else if (n < 1000) {
            sb.append("0");
        }
        sb.append(n);
        n = calendar.get(2) + 1;
        if (n < 10) {
            sb.append("0");
        }
        sb.append(n);
        n = calendar.get(5);
        if (n < 10) {
            sb.append("0");
        }
        sb.append(n);
        n = calendar.get(11);
        if (n < 10) {
            sb.append("0");
        }
        sb.append(n);
        n = calendar.get(12);
        if (n < 10) {
            sb.append("0");
        }
        sb.append(n);
        n = calendar.get(13);
        if (n < 10) {
            sb.append("0");
        }
        sb.append(n);
        sb.append('.');
        n = calendar.get(14);
        if (n < 10) {
            sb.append("00");
        } else if (n < 100) {
            sb.append("0");
        }
        sb.append(n);
        sb.append('Z');
        return sb.toString();
    }

    public static byte[] getBytes(char[] chars) {
        Charset utf8 = Charset.forName("UTF-8");
        ByteBuffer buffer = utf8.encode(CharBuffer.wrap(chars));
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    public static byte[] getBytes(String s) {
        if (s == null) {
            return null;
        }
        try {
            int length = s.length();
            byte[] returnArray = new byte[length];
            for (int i = 0; i < length; ++i) {
                char c = s.charAt(i);
                returnArray[i] = (byte)(c & 0x7F);
                if (c == returnArray[i]) continue;
                return s.getBytes("UTF-8");
            }
            return returnArray;
        }
        catch (Exception e) {
            DEBUG_LOG.warning("Unable to encode UTF-8 string " + s);
            return s.getBytes();
        }
    }

    public static LocalizableMessage getExceptionMessage(Throwable t) {
        if (t instanceof LocalizableException) {
            LocalizableException ie = (LocalizableException)t;
            return ie.getMessageObject();
        }
        if (t instanceof NullPointerException) {
            StackTraceElement[] stackElements = t.getStackTrace();
            LocalizableMessageBuilder message = new LocalizableMessageBuilder();
            message.append((CharSequence)"NullPointerException(");
            message.append((CharSequence)stackElements[0].getFileName());
            message.append((CharSequence)":");
            message.append(stackElements[0].getLineNumber());
            message.append((CharSequence)")");
            return message.toMessage();
        }
        if (t instanceof InvocationTargetException && t.getCause() != null) {
            return StaticUtils.getExceptionMessage(t.getCause());
        }
        StringBuilder message = new StringBuilder();
        String className = t.getClass().getName();
        int periodPos = className.lastIndexOf(46);
        if (periodPos > 0) {
            message.append(className.substring(periodPos + 1));
        } else {
            message.append(className);
        }
        message.append("(");
        if (t.getMessage() == null) {
            StackTraceElement[] stackElements = t.getStackTrace();
            message.append(stackElements[0].getFileName());
            message.append(":");
            message.append(stackElements[0].getLineNumber());
            if (t instanceof IllegalStateException) {
                for (int i = 1; i < stackElements.length; ++i) {
                    message.append(' ');
                    message.append(stackElements[i].getFileName());
                    message.append(":");
                    message.append(stackElements[i].getLineNumber());
                }
            }
        } else {
            message.append(t.getMessage());
        }
        message.append(")");
        return LocalizableMessage.raw((CharSequence)message.toString(), (Object[])new Object[0]);
    }

    public static byte[] hexStringToByteArray(String hexString) throws ParseException {
        int length;
        if (hexString == null || (length = hexString.length()) == 0) {
            return new byte[0];
        }
        if (length % 2 != 0) {
            LocalizableMessage message = CoreMessages.ERR_HEX_DECODE_INVALID_LENGTH.get((Object)hexString);
            throw new ParseException(message.toString(), 0);
        }
        int arrayLength = length / 2;
        byte[] returnArray = new byte[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            returnArray[i] = StaticUtils.hexToByte(hexString.charAt(i * 2), hexString.charAt(i * 2 + 1));
        }
        return returnArray;
    }

    public static byte hexToByte(char c1, char c2) throws ParseException {
        byte b;
        switch (c1) {
            case '0': {
                b = 0;
                break;
            }
            case '1': {
                b = 16;
                break;
            }
            case '2': {
                b = 32;
                break;
            }
            case '3': {
                b = 48;
                break;
            }
            case '4': {
                b = 64;
                break;
            }
            case '5': {
                b = 80;
                break;
            }
            case '6': {
                b = 96;
                break;
            }
            case '7': {
                b = 112;
                break;
            }
            case '8': {
                b = -128;
                break;
            }
            case '9': {
                b = -112;
                break;
            }
            case 'A': 
            case 'a': {
                b = -96;
                break;
            }
            case 'B': 
            case 'b': {
                b = -80;
                break;
            }
            case 'C': 
            case 'c': {
                b = -64;
                break;
            }
            case 'D': 
            case 'd': {
                b = -48;
                break;
            }
            case 'E': 
            case 'e': {
                b = -32;
                break;
            }
            case 'F': 
            case 'f': {
                b = -16;
                break;
            }
            default: {
                LocalizableMessage message = CoreMessages.ERR_HEX_DECODE_INVALID_CHARACTER.get((Object)new String(new char[]{c1, c2}), (Object)Character.valueOf(c1));
                throw new ParseException(message.toString(), 0);
            }
        }
        switch (c2) {
            case '0': {
                break;
            }
            case '1': {
                b = (byte)(b | 1);
                break;
            }
            case '2': {
                b = (byte)(b | 2);
                break;
            }
            case '3': {
                b = (byte)(b | 3);
                break;
            }
            case '4': {
                b = (byte)(b | 4);
                break;
            }
            case '5': {
                b = (byte)(b | 5);
                break;
            }
            case '6': {
                b = (byte)(b | 6);
                break;
            }
            case '7': {
                b = (byte)(b | 7);
                break;
            }
            case '8': {
                b = (byte)(b | 8);
                break;
            }
            case '9': {
                b = (byte)(b | 9);
                break;
            }
            case 'A': 
            case 'a': {
                b = (byte)(b | 0xA);
                break;
            }
            case 'B': 
            case 'b': {
                b = (byte)(b | 0xB);
                break;
            }
            case 'C': 
            case 'c': {
                b = (byte)(b | 0xC);
                break;
            }
            case 'D': 
            case 'd': {
                b = (byte)(b | 0xD);
                break;
            }
            case 'E': 
            case 'e': {
                b = (byte)(b | 0xE);
                break;
            }
            case 'F': 
            case 'f': {
                b = (byte)(b | 0xF);
                break;
            }
            default: {
                LocalizableMessage message = CoreMessages.ERR_HEX_DECODE_INVALID_CHARACTER.get((Object)new String(new char[]{c1, c2}), (Object)Character.valueOf(c1));
                throw new ParseException(message.toString(), 0);
            }
        }
        return b;
    }

    public static boolean isAlpha(char c) {
        ASCIICharProp cp = ASCIICharProp.valueOf(c);
        return cp != null ? cp.isLetter() : false;
    }

    public static boolean isDigit(char c) {
        ASCIICharProp cp = ASCIICharProp.valueOf(c);
        return cp != null ? cp.isDigit() : false;
    }

    public static boolean isHexDigit(char c) {
        ASCIICharProp cp = ASCIICharProp.valueOf(c);
        return cp != null ? cp.isHexDigit() : false;
    }

    public static boolean isKeyChar(char c, boolean allowCompatChars) {
        ASCIICharProp cp = ASCIICharProp.valueOf(c);
        return cp != null ? cp.isKeyChar(allowCompatChars) : false;
    }

    public static String joinCollection(Collection<?> c, String separator) {
        Validator.ensureNotNull(c, (Object)separator);
        switch (c.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return String.valueOf(c.iterator().next());
            }
        }
        StringBuilder builder = new StringBuilder();
        Iterator<?> i = c.iterator();
        builder.append(i.next());
        while (i.hasNext()) {
            builder.append(separator);
            builder.append(i.next());
        }
        String s = builder.toString();
        return s;
    }

    public static ThreadFactory newThreadFactory(final ThreadGroup group, final String nameTemplate, final boolean isDaemon) {
        return new ThreadFactory(){
            private final AtomicInteger count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                String name = String.format(nameTemplate, this.count.getAndIncrement());
                Thread t = new Thread(group, r, name);
                t.setDaemon(isDaemon);
                return t;
            }
        };
    }

    public static String toHex(ByteSequence bytes) {
        return StaticUtils.toHex(bytes, new StringBuilder((bytes.length() - 1) * 3 + 2)).toString();
    }

    public static StringBuilder toHex(ByteSequence bytes, StringBuilder builder) {
        int length = bytes.length();
        builder.ensureCapacity(builder.length() + (length - 1) * 3 + 2);
        builder.append(StaticUtils.byteToHex(bytes.byteAt(0)));
        for (int i = 1; i < length; ++i) {
            builder.append(" ");
            builder.append(StaticUtils.byteToHex(bytes.byteAt(i)));
        }
        return builder;
    }

    public static StringBuilder toHexPlusAscii(ByteSequence bytes, StringBuilder builder, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        int length = bytes.length();
        int pos = 0;
        while (length - pos >= 16) {
            StringBuilder asciiBuf = new StringBuilder(17);
            byte currentByte = bytes.byteAt(pos);
            builder.append((CharSequence)indentBuf);
            builder.append(StaticUtils.byteToHex(currentByte));
            asciiBuf.append(StaticUtils.byteToASCII(currentByte));
            ++pos;
            int i = 1;
            while (i < 16) {
                currentByte = bytes.byteAt(pos);
                builder.append(' ');
                builder.append(StaticUtils.byteToHex(currentByte));
                asciiBuf.append(StaticUtils.byteToASCII(currentByte));
                if (i == 7) {
                    builder.append("  ");
                    asciiBuf.append(' ');
                }
                ++i;
                ++pos;
            }
            builder.append("  ");
            builder.append((CharSequence)asciiBuf);
            builder.append(EOL);
        }
        int remaining = length - pos;
        if (remaining > 0) {
            StringBuilder asciiBuf = new StringBuilder(remaining + 1);
            byte currentByte = bytes.byteAt(pos);
            builder.append((CharSequence)indentBuf);
            builder.append(StaticUtils.byteToHex(currentByte));
            asciiBuf.append(StaticUtils.byteToASCII(currentByte));
            ++pos;
            int i = 1;
            while (i < 16) {
                builder.append(' ');
                if (i < remaining) {
                    currentByte = bytes.byteAt(pos);
                    builder.append(StaticUtils.byteToHex(currentByte));
                    asciiBuf.append(StaticUtils.byteToASCII(currentByte));
                } else {
                    builder.append("  ");
                }
                if (i == 7) {
                    builder.append("  ");
                    if (i < remaining) {
                        asciiBuf.append(' ');
                    }
                }
                ++i;
                ++pos;
            }
            builder.append("  ");
            builder.append((CharSequence)asciiBuf);
            builder.append(EOL);
        }
        return builder;
    }

    public static StringBuilder toLowerCase(ByteSequence b, StringBuilder builder) {
        Validator.ensureNotNull((Object)b, (Object)builder);
        int origBufferLen = builder.length();
        int length = b.length();
        for (int i = 0; i < length; ++i) {
            byte c = b.byteAt(i);
            if (c < 0) {
                builder.replace(origBufferLen, builder.length(), b.toString().toLowerCase(Locale.ENGLISH));
                return builder;
            }
            ASCIICharProp cp = ASCIICharProp.valueOf(c);
            builder.append(cp.toLowerCase());
        }
        return builder;
    }

    public static String toLowerCase(String s) {
        int i;
        Validator.ensureNotNull(s);
        int length = s.length();
        ASCIICharProp cp = null;
        for (i = 0; i < length && (cp = ASCIICharProp.valueOf(s.charAt(i))) != null && !cp.isUpperCase(); ++i) {
        }
        if (i == length) {
            return s;
        }
        StringBuilder builder = new StringBuilder(length);
        builder.append(s, 0, i);
        if (cp != null) {
            builder.append(cp.toLowerCase());
            ++i;
            while (i < length && (cp = ASCIICharProp.valueOf(s.charAt(i))) != null) {
                builder.append(cp.toLowerCase());
                ++i;
            }
        }
        if (i < length) {
            builder.append(s.substring(i).toLowerCase(Locale.ENGLISH));
        }
        return builder.toString();
    }

    public static StringBuilder toLowerCase(String s, StringBuilder builder) {
        Validator.ensureNotNull((Object)s, (Object)builder);
        int length = s.length();
        builder.ensureCapacity(builder.length() + length);
        for (int i = 0; i < length; ++i) {
            ASCIICharProp cp = ASCIICharProp.valueOf(s.charAt(i));
            if (cp == null) {
                builder.append(s.substring(i).toLowerCase(Locale.ENGLISH));
                return builder;
            }
            builder.append(cp.toLowerCase());
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int uncompress(byte[] src, int srcOff, int srcLen, byte[] dst, int dstOff, int dstLen) throws DataFormatException {
        Inflater inflater = new Inflater();
        try {
            inflater.setInput(src, srcOff, srcLen);
            int decompressedLength = inflater.inflate(dst, dstOff, dstLen);
            if (inflater.finished()) {
                int n = decompressedLength;
                return n;
            }
            int totalLength = decompressedLength;
            while (!inflater.finished()) {
                totalLength += inflater.inflate(dst, dstOff, dstLen);
            }
            int n = -totalLength;
            return n;
        }
        finally {
            inflater.end();
        }
    }

    public static boolean uncompress(ByteSequence input, ByteStringBuilder output, int uncompressedSize) throws DataFormatException {
        byte[] outputBytes;
        byte[] inputBytes = input.toByteArray();
        int decompressResult = StaticUtils.uncompress(inputBytes, 0, inputBytes.length, outputBytes = new byte[uncompressedSize > 0 ? uncompressedSize : 0], 0, outputBytes.length);
        if (decompressResult < 0) {
            outputBytes = new byte[-decompressResult];
            decompressResult = StaticUtils.uncompress(inputBytes, 0, inputBytes.length, outputBytes, 0, outputBytes.length);
        }
        if (decompressResult >= 0) {
            output.append(outputBytes, 0, decompressResult);
            return true;
        }
        return false;
    }

    public static byte[] copyOfBytes(byte[] bytes) {
        return Arrays.copyOf(bytes, bytes.length);
    }

    private static char byteToASCII(byte b) {
        if (b >= 32 && b <= 126) {
            return (char)b;
        }
        return ' ';
    }

    private StaticUtils() {
    }
}

