/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import com.forgerock.opendj.util.AsynchronousFutureResult;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.ResultHandler;

public abstract class RecursiveFutureResult<M, N>
implements FutureResult<N>,
ResultHandler<M> {
    private final FutureResultImpl impl;
    private volatile Future<?> innerFuture = null;
    private FutureResult<? extends N> outerFuture = null;

    protected RecursiveFutureResult(ResultHandler<? super N> handler) {
        this.impl = new FutureResultImpl(handler);
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        return this.impl.cancel(mayInterruptIfRunning);
    }

    @Override
    public final N get() throws ErrorResultException, InterruptedException {
        return (N)this.impl.get();
    }

    @Override
    public final N get(long timeout, TimeUnit unit) throws ErrorResultException, TimeoutException, InterruptedException {
        return (N)this.impl.get(timeout, unit);
    }

    @Override
    public final int getRequestID() {
        return this.impl.getRequestID();
    }

    @Override
    public final void handleErrorResult(ErrorResultException error) {
        try {
            this.outerFuture = this.chainErrorResult(error, this.impl);
        }
        catch (ErrorResultException e) {
            this.impl.handleErrorResult(e);
        }
    }

    @Override
    public final void handleResult(M result) {
        try {
            this.outerFuture = this.chainResult(result, this.impl);
        }
        catch (ErrorResultException e) {
            this.impl.handleErrorResult(e);
        }
    }

    @Override
    public final boolean isCancelled() {
        return this.impl.isCancelled();
    }

    @Override
    public final boolean isDone() {
        return this.impl.isDone();
    }

    public final void setFutureResult(Future<?> future) {
        this.innerFuture = future;
    }

    protected FutureResult<? extends N> chainErrorResult(ErrorResultException innerError, ResultHandler<? super N> handler) throws ErrorResultException {
        throw innerError;
    }

    protected abstract FutureResult<? extends N> chainResult(M var1, ResultHandler<? super N> var2) throws ErrorResultException;

    private final class FutureResultImpl
    extends AsynchronousFutureResult<N, ResultHandler<? super N>> {
        private FutureResultImpl(ResultHandler<? super N> handler) {
            super(handler);
        }

        @Override
        public int getRequestID() {
            if (RecursiveFutureResult.this.innerFuture instanceof FutureResult) {
                FutureResult tmp = (FutureResult)RecursiveFutureResult.this.innerFuture;
                return tmp.getRequestID();
            }
            return -1;
        }

        @Override
        protected ErrorResultException handleCancelRequest(boolean mayInterruptIfRunning) {
            RecursiveFutureResult.this.innerFuture.cancel(mayInterruptIfRunning);
            if (RecursiveFutureResult.this.outerFuture != null) {
                RecursiveFutureResult.this.outerFuture.cancel(mayInterruptIfRunning);
            }
            return null;
        }
    }
}

