/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import java.io.IOException;
import java.io.OutputStream;
import org.forgerock.opendj.ldap.ByteStringBuilder;

public final class ByteSequenceOutputStream
extends OutputStream {
    private final ByteStringBuilder buffer;

    public ByteSequenceOutputStream(ByteStringBuilder buffer) {
        this.buffer = buffer;
    }

    @Override
    public void close() throws IOException {
        this.buffer.clear();
    }

    public int length() {
        return this.buffer.length();
    }

    public void reset() {
        this.buffer.clear();
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.buffer.append(bytes);
    }

    @Override
    public void write(byte[] bytes, int i, int i1) throws IOException {
        this.buffer.append(bytes, i, i1);
    }

    @Override
    public void write(int i) throws IOException {
        this.buffer.append((byte)(i & 0xFF));
    }

    public void writeTo(OutputStream stream) throws IOException {
        this.buffer.copyTo(stream);
    }
}

