/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.extensions;

import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.asn1.ASN1;
import org.forgerock.opendj.asn1.ASN1Reader;
import org.forgerock.opendj.asn1.ASN1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.requests.AbstractExtendedRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequestDecoder;
import org.forgerock.opendj.ldap.responses.AbstractExtendedResultDecoder;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.ExtendedResultDecoder;
import org.forgerock.opendj.ldap.responses.Responses;

public final class GetSymmetricKeyExtendedRequest
extends AbstractExtendedRequest<GetSymmetricKeyExtendedRequest, ExtendedResult> {
    public static final String OID = "1.3.6.1.4.1.26027.1.6.3";
    private static final byte TYPE_SYMMETRIC_KEY_ELEMENT = -128;
    private static final byte TYPE_INSTANCE_KEY_ID_ELEMENT = -127;
    public static final RequestDecoder REQUEST_DECODER = new RequestDecoder();
    private static final ResultDecoder RESULT_DECODER = new ResultDecoder();
    private String requestSymmetricKey = null;
    private String instanceKeyID = null;

    public static GetSymmetricKeyExtendedRequest newRequest() {
        return new GetSymmetricKeyExtendedRequest();
    }

    private GetSymmetricKeyExtendedRequest() {
    }

    public String getInstanceKeyID() {
        return this.instanceKeyID;
    }

    @Override
    public String getOID() {
        return OID;
    }

    public String getRequestSymmetricKey() {
        return this.requestSymmetricKey;
    }

    @Override
    public ExtendedResultDecoder<ExtendedResult> getResultDecoder() {
        return RESULT_DECODER;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder();
        ASN1Writer writer = ASN1.getWriter(buffer);
        try {
            writer.writeStartSequence();
            if (this.requestSymmetricKey != null) {
                writer.writeOctetString((byte)-128, this.requestSymmetricKey);
            }
            if (this.instanceKeyID != null) {
                writer.writeOctetString((byte)-127, this.instanceKeyID);
            }
            writer.writeEndSequence();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return buffer.toByteString();
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    public GetSymmetricKeyExtendedRequest setInstanceKeyID(String instanceKeyID) {
        this.instanceKeyID = instanceKeyID;
        return this;
    }

    public GetSymmetricKeyExtendedRequest setRequestSymmetricKey(String requestSymmetricKey) {
        this.requestSymmetricKey = requestSymmetricKey;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GetSymmetricKeyExtendedRequest(requestName=");
        builder.append(this.getOID());
        builder.append(", requestSymmetricKey=");
        builder.append(this.requestSymmetricKey);
        builder.append(", instanceKeyID=");
        builder.append(this.instanceKeyID);
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    private static final class ResultDecoder
    extends AbstractExtendedResultDecoder<ExtendedResult> {
        private ResultDecoder() {
        }

        @Override
        public ExtendedResult newExtendedErrorResult(ResultCode resultCode, String matchedDN, String diagnosticMessage) {
            return Responses.newGenericExtendedResult(resultCode).setMatchedDN(matchedDN).setDiagnosticMessage(diagnosticMessage);
        }

        @Override
        public ExtendedResult decodeExtendedResult(ExtendedResult result, DecodeOptions options) throws DecodeException {
            return result;
        }
    }

    private static final class RequestDecoder
    implements ExtendedRequestDecoder<GetSymmetricKeyExtendedRequest, ExtendedResult> {
        private RequestDecoder() {
        }

        @Override
        public GetSymmetricKeyExtendedRequest decodeExtendedRequest(ExtendedRequest<?> request, DecodeOptions options) throws DecodeException {
            ByteString requestValue = request.getValue();
            if (requestValue == null) {
                LocalizableMessage message = CoreMessages.ERR_GET_SYMMETRIC_KEY_NO_VALUE.get();
                throw DecodeException.error(message);
            }
            String requestSymmetricKey = null;
            String instanceKeyID = null;
            try {
                ASN1Reader reader = ASN1.getReader(requestValue);
                reader.readStartSequence();
                if (reader.hasNextElement() && reader.peekType() == -128) {
                    requestSymmetricKey = reader.readOctetStringAsString();
                }
                if (reader.hasNextElement() && reader.peekType() == -127) {
                    instanceKeyID = reader.readOctetStringAsString();
                }
                reader.readEndSequence();
                GetSymmetricKeyExtendedRequest newRequest = new GetSymmetricKeyExtendedRequest().setRequestSymmetricKey(requestSymmetricKey).setInstanceKeyID(instanceKeyID);
                for (Control control : request.getControls()) {
                    newRequest.addControl(control);
                }
                return newRequest;
            }
            catch (IOException ae) {
                StaticUtils.DEBUG_LOG.throwing("GetSymmetricKeyRequest.Operation", "decodeRequest", ae);
                LocalizableMessage message = CoreMessages.ERR_GET_SYMMETRIC_KEY_ASN1_DECODE_EXCEPTION.get((Object)ae.getMessage());
                throw DecodeException.error(message, ae);
            }
        }
    }
}

