/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.util.Validator;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;

public final class VirtualAttributesOnlyRequestControl
implements Control {
    public static final String OID = "2.16.840.1.113730.3.4.19";
    private static final VirtualAttributesOnlyRequestControl CRITICAL_INSTANCE = new VirtualAttributesOnlyRequestControl(true);
    private static final VirtualAttributesOnlyRequestControl NONCRITICAL_INSTANCE = new VirtualAttributesOnlyRequestControl(false);
    public static final ControlDecoder<VirtualAttributesOnlyRequestControl> DECODER = new ControlDecoder<VirtualAttributesOnlyRequestControl>(){

        @Override
        public VirtualAttributesOnlyRequestControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            Validator.ensureNotNull(control);
            if (control instanceof VirtualAttributesOnlyRequestControl) {
                return (VirtualAttributesOnlyRequestControl)control;
            }
            if (!control.getOID().equals(VirtualAttributesOnlyRequestControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_VIRTUAL_ATTRS_ONLY_CONTROL_BAD_OID.get((Object)control.getOID(), (Object)VirtualAttributesOnlyRequestControl.OID);
                throw DecodeException.error(message);
            }
            if (control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_VIRTUAL_ATTRS_ONLY_INVALID_CONTROL_VALUE.get();
                throw DecodeException.error(message);
            }
            return control.isCritical() ? CRITICAL_INSTANCE : NONCRITICAL_INSTANCE;
        }

        @Override
        public String getOID() {
            return VirtualAttributesOnlyRequestControl.OID;
        }
    };
    private final boolean isCritical;

    public static VirtualAttributesOnlyRequestControl newControl(boolean isCritical) {
        return isCritical ? CRITICAL_INSTANCE : NONCRITICAL_INSTANCE;
    }

    private VirtualAttributesOnlyRequestControl(boolean isCritical) {
        this.isCritical = isCritical;
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        return null;
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VirtualAttributesOnlyRequestControl(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(")");
        return builder.toString();
    }
}

