/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.LDAPMessageHandler;
import com.forgerock.opendj.ldap.LDAPUtils;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import java.util.logging.Level;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.asn1.ASN1Reader;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.DereferenceAliasesPolicy;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.GenericBindRequest;
import org.forgerock.opendj.ldap.requests.GenericExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.GenericExtendedResult;
import org.forgerock.opendj.ldap.responses.GenericIntermediateResponse;
import org.forgerock.opendj.ldap.responses.Response;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldap.schema.Schema;

final class LDAPReader {
    private final DecodeOptions options;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SearchResultEntry decodeEntry(ASN1Reader reader, DecodeOptions options) throws IOException {
        Entry entry;
        reader.readStartSequence((byte)100);
        try {
            DN dn;
            String dnString = reader.readOctetStringAsString();
            Schema schema = options.getSchemaResolver().resolveSchema(dnString);
            try {
                dn = DN.valueOf(dnString, schema);
            }
            catch (LocalizedIllegalArgumentException e) {
                throw DecodeException.error(e.getMessageObject());
            }
            entry = options.getEntryFactory().newEntry(dn);
            reader.readStartSequence();
            try {
                while (reader.hasNextElement()) {
                    reader.readStartSequence();
                    try {
                        AttributeDescription ad;
                        String ads = reader.readOctetStringAsString();
                        try {
                            ad = AttributeDescription.valueOf(ads, schema);
                        }
                        catch (LocalizedIllegalArgumentException e) {
                            throw DecodeException.error(e.getMessageObject());
                        }
                        Attribute attribute = options.getAttributeFactory().newAttribute(ad);
                        reader.readStartSet();
                        try {
                            while (reader.hasNextElement()) {
                                attribute.add(reader.readOctetString());
                            }
                            entry.addAttribute(attribute);
                        }
                        finally {
                            reader.readEndSet();
                        }
                    }
                    finally {
                        reader.readEndSequence();
                    }
                }
            }
            finally {
                reader.readEndSequence();
            }
        }
        finally {
            reader.readEndSequence();
        }
        return Responses.newSearchResultEntry(entry);
    }

    LDAPReader(DecodeOptions options) {
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <P> void decode(ASN1Reader reader, LDAPMessageHandler<P> handler, P param) throws IOException {
        reader.readStartSequence();
        try {
            int messageID = (int)reader.readInteger();
            this.decodeProtocolOp(reader, messageID, handler, param);
        }
        finally {
            reader.readEndSequence();
        }
    }

    private <P> void decodeAbandonRequest(ASN1Reader reader, int messageID, LDAPMessageHandler<P> handler, P p) throws IOException {
        int msgToAbandon = (int)reader.readInteger((byte)80);
        AbandonRequest message = Requests.newAbandonRequest(msgToAbandon);
        this.decodeControls(reader, message);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("DECODE LDAP ABANDON REQUEST(messageID=%d, request=%s)", messageID, message));
        }
        handler.abandonRequest(p, messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P> void decodeAddRequest(ASN1Reader reader, int messageID, LDAPMessageHandler<P> handler, P p) throws IOException {
        Entry entry;
        reader.readStartSequence((byte)104);
        try {
            String dnString = reader.readOctetStringAsString();
            Schema schema = this.options.getSchemaResolver().resolveSchema(dnString);
            DN dn = this.decodeDN(dnString, schema);
            entry = this.options.getEntryFactory().newEntry(dn);
            reader.readStartSequence();
            try {
                while (reader.hasNextElement()) {
                    reader.readStartSequence();
                    try {
                        String ads = reader.readOctetStringAsString();
                        AttributeDescription ad = this.decodeAttributeDescription(ads, schema);
                        Attribute attribute = this.options.getAttributeFactory().newAttribute(ad);
                        reader.readStartSet();
                        try {
                            while (reader.hasNextElement()) {
                                attribute.add(reader.readOctetString());
                            }
                            entry.addAttribute(attribute);
                        }
                        finally {
                            reader.readEndSet();
                        }
                    }
                    finally {
                        reader.readEndSequence();
                    }
                }
            }
            finally {
                reader.readEndSequence();
            }
        }
        finally {
            reader.readEndSequence();
        }
        AddRequest message = Requests.newAddRequest(entry);
        this.decodeControls(reader, message);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("DECODE LDAP ADD REQUEST(messageID=%d, request=%s)", messageID, message));
        }
        handler.addRequest(p, messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P> void decodeAddResult(ASN1Reader reader, int messageID, LDAPMessageHandler<P> handler, P p) throws IOException {
        Result message;
        reader.readStartSequence((byte)105);
        try {
            ResultCode resultCode = ResultCode.valueOf(reader.readEnumerated());
            String matchedDN = reader.readOctetStringAsString();
            String diagnosticMessage = reader.readOctetStringAsString();
            message = Responses.newResult(resultCode).setMatchedDN(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.decodeResponseReferrals(reader, message);
        }
        finally {
            reader.readEndSequence();
        }
        this.decodeControls(reader, message);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("DECODE LDAP ADD RESULT(messageID=%d, result=%s)", messageID, message));
        }
        handler.addResult(p, messageID, message);
    }

    private AttributeDescription decodeAttributeDescription(String attributeDescription, Schema schema) throws DecodeException {
        try {
            return AttributeDescription.valueOf(attributeDescription, schema);
        }
        catch (LocalizedIllegalArgumentException e) {
            throw DecodeException.error(e.getMessageObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P> void decodeBindRequest(ASN1Reader reader, int messageID, LDAPMessageHandler<P> handler, P p) throws IOException {
        reader.readStartSequence((byte)96);
        try {
            int protocolVersion = (int)reader.readInteger();
            String authName = reader.readOctetStringAsString();
            byte authType = reader.peekType();
            byte[] authBytes = reader.readOctetString(authType).toByteArray();
            GenericBindRequest request = Requests.newGenericBindRequest(authName, authType, authBytes);
            this.decodeControls(reader, request);
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
                StaticUtils.DEBUG_LOG.finer(String.format("DECODE LDAP BIND REQUEST(messageID=%d, auth=0x%x, request=%s)", messageID, request.getAuthenticationType(), request));
            }
            handler.bindRequest(p, messageID, protocolVersion, request);
        }
        finally {
            reader.readEndSequence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P> void decodeBindResult(ASN1Reader reader, int messageID, LDAPMessageHandler<P> handler, P p) throws IOException {
        BindResult message;
        reader.readStartSequence((byte)97);
        try {
            ResultCode resultCode = ResultCode.valueOf(reader.readEnumerated());
            String matchedDN = reader.readOctetStringAsString();
            String diagnosticMessage = reader.readOctetStringAsString();
            message = Responses.newBindResult(resultCode).setMatchedDN(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.decodeResponseReferrals(reader, message);
            if (reader.hasNextElement() && reader.peekType() == -121) {
                message.setServerSASLCredentials(reader.readOctetString((byte)-121));
            }
        }
        finally {
            reader.readEndSequence();
        }
        this.decodeControls(reader, message);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("DECODE LDAP BIND RESULT(messageID=%d, result=%s)", messageID, message));
        }
        handler.bindResult(p, messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P> void decodeCompareRequest(ASN1Reader reader, int messageID, LDAPMessageHandler<P> handler, P p) throws IOException {
        CompareRequest message;
        reader.readStartSequence((byte)110);
        try {
            String dnString = reader.readOctetStringAsString();
            Schema schema = this.options.getSchemaResolver().resolveSchema(dnString);
            DN dn = this.decodeDN(dnString, schema);
            reader.readStartSequence();
            try {
                String ads = reader.readOctetStringAsString();
                AttributeDescription ad = this.decodeAttributeDescription(ads, schema);
                ByteString assertionValue = reader.readOctetString();
                message = Requests.newCompareRequest(dn, ad, (Object)assertionValue);
            }
            finally {
                reader.readEndSequence();
            }
        }
        finally {
            reader.readEndSequence();
        }
        this.decodeControls(reader, message);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("DECODE LDAP COMPARE REQUEST(messageID=%d, request=%s)", messageID, message));
        }
        handler.compareRequest(p, messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P> void decodeCompareResult(ASN1Reader reader, int messageID, LDAPMessageHandler<P> handler, P p) throws IOException {
        CompareResult message;
        reader.readStartSequence((byte)111);
        try {
            ResultCode resultCode = ResultCode.valueOf(reader.readEnumerated());
            String matchedDN = reader.readOctetStringAsString();
            String diagnosticMessage = reader.readOctetStringAsString();
            message = Responses.newCompareResult(resultCode).setMatchedDN(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.decodeResponseReferrals(reader, message);
        }
        finally {
            reader.readEndSequence();
        }
        this.decodeControls(reader, message);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("DECODE LDAP COMPARE RESULT(messageID=%d, result=%s)", messageID, message));
        }
        handler.compareResult(p, messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeControl(ASN1Reader reader, Request request) throws IOException {
        ByteString value;
        boolean isCritical;
        String oid;
        reader.readStartSequence();
        try {
            oid = reader.readOctetStringAsString();
            isCritical = false;
            value = null;
            if (reader.hasNextElement() && reader.peekType() == 1) {
                isCritical = reader.readBoolean();
            }
            if (reader.hasNextElement() && reader.peekType() == 4) {
                value = reader.readOctetString();
            }
        }
        finally {
            reader.readEndSequence();
        }
        GenericControl c = GenericControl.newControl(oid, isCritical, value);
        request.addControl(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeControl(ASN1Reader reader, Response response) throws IOException {
        ByteString value;
        boolean isCritical;
        String oid;
        reader.readStartSequence();
        try {
            oid = reader.readOctetStringAsString();
            isCritical = false;
            value = null;
            if (reader.hasNextElement() && reader.peekType() == 1) {
                isCritical = reader.readBoolean();
            }
            if (reader.hasNextElement() && reader.peekType() == 4) {
                value = reader.readOctetString();
            }
        }
        finally {
            reader.readEndSequence();
        }
        GenericControl c = GenericControl.newControl(oid, isCritical, value);
        response.addControl(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeControls(ASN1Reader reader, Request request) throws IOException {
        if (reader.hasNextElement() && reader.peekType() == -96) {
            reader.readStartSequence((byte)-96);
            try {
                while (reader.hasNextElement()) {
                    this.decodeControl(reader, request);
                }
            }
            finally {
                reader.readEndSequence();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeControls(ASN1Reader reader, Response response) throws IOException {
        if (reader.hasNextElement() && reader.peekType() == -96) {
            reader.readStartSequence((byte)-96);
            try {
                while (reader.hasNextElement()) {
                    this.decodeControl(reader, response);
                }
            }
            finally {
                reader.readEndSequence();
            }
        }
    }

    private <P> void decodeDeleteRequest(ASN1Reader reader, int messageID, LDAPMessageHandler<P> handler, P p) throws IOException {
        String dnString = reader.readOctetStringAsString((byte)74);
        Schema schema = this.options.getSchemaResolver().resolveSchema(dnString);
        DN dn = this.decodeDN(dnString, schema);
        DeleteRequest message = Requests.newDeleteRequest(dn);
        this.decodeControls(reader, message);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("DECODE LDAP DELETE REQUEST(messageID=%d, request=%s)", messageID, message));
        }
        handler.deleteRequest(p, messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P> void decodeDeleteResult(ASN1Reader reader, int messageID, LDAPMessageHandler<P> handler, P p) throws IOException {
        Result message;
        reader.readStartSequence((byte)107);
        try {
            ResultCode resultCode = ResultCode.valueOf(reader.readEnumerated());
            String matchedDN = reader.readOctetStringAsString();
            String diagnosticMessage = reader.readOctetStringAsString();
            message = Responses.newResult(resultCode).setMatchedDN(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.decodeResponseReferrals(reader, message);
        }
        finally {
            reader.readEndSequence();
        }
        this.decodeControls(reader, message);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("DECODE LDAP DELETE RESULT(messageID=%d, result=%s)", messageID, message));
        }
        handler.deleteResult(p, messageID, message);
    }

    private DN decodeDN(String dn, Schema schema) throws DecodeException {
        try {
            return DN.valueOf(dn, schema);
        }
        catch (LocalizedIllegalArgumentException e) {
            throw DecodeException.error(e.getMessageObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P> void decodeExtendedRequest(ASN1Reader reader, int messageID, LDAPMessageHandler<P> handler, P p) throws IOException {
        ByteString value;
        String oid;
        reader.readStartSequence((byte)119);
        try {
            oid = reader.readOctetStringAsString((byte)-128);
            value = null;
            if (reader.hasNextElement() && reader.peekType() == -127) {
                value = reader.readOctetString((byte)-127);
            }
        }
        finally {
            reader.readEndSequence();
        }
        GenericExtendedRequest message = Requests.newGenericExtendedRequest(oid, value);
        this.decodeControls(reader, message);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("DECODE LDAP EXTENDED REQUEST(messageID=%d, request=%s)", messageID, message));
        }
        handler.extendedRequest(p, messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P> void decodeExtendedResult(ASN1Reader reader, int messageID, LDAPMessageHandler<P> handler, P p) throws IOException {
        GenericExtendedResult message;
        reader.readStartSequence((byte)120);
        try {
            ResultCode resultCode = ResultCode.valueOf(reader.readEnumerated());
            String matchedDN = reader.readOctetStringAsString();
            String diagnosticMessage = reader.readOctetStringAsString();
            message = Responses.newGenericExtendedResult(resultCode).setMatchedDN(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.decodeResponseReferrals(reader, message);
            if (reader.hasNextElement() && reader.peekType() == -118) {
                message.setOID(reader.readOctetStringAsString((byte)-118));
            }
            if (reader.hasNextElement() && reader.peekType() == -117) {
                message.setValue(reader.readOctetString((byte)-117));
            }
        }
        finally {
            reader.readEndSequence();
        }
        this.decodeControls(reader, message);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("DECODE LDAP EXTENDED RESULT(messageID=%d, result=%s)", messageID, message));
        }
        handler.extendedResult(p, messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P> void decodeIntermediateResponse(ASN1Reader reader, int messageID, LDAPMessageHandler<P> handler, P p) throws IOException {
        GenericIntermediateResponse message;
        reader.readStartSequence((byte)121);
        try {
            message = Responses.newGenericIntermediateResponse();
            if (reader.hasNextElement() && reader.peekType() == -128) {
                message.setOID(reader.readOctetStringAsString((byte)-128));
            }
            if (reader.hasNextElement() && reader.peekType() == -127) {
                message.setValue(reader.readOctetString((byte)-127));
            }
        }
        finally {
            reader.readEndSequence();
        }
        this.decodeControls(reader, message);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("DECODE LDAP INTERMEDIATE RESPONSE(messageID=%d, response=%s)", messageID, message));
        }
        handler.intermediateResponse(p, messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P> void decodeModifyDNRequest(ASN1Reader reader, int messageID, LDAPMessageHandler<P> handler, P p) throws IOException {
        ModifyDNRequest message;
        reader.readStartSequence((byte)108);
        try {
            String dnString = reader.readOctetStringAsString();
            Schema schema = this.options.getSchemaResolver().resolveSchema(dnString);
            DN dn = this.decodeDN(dnString, schema);
            String newRDNString = reader.readOctetStringAsString();
            RDN newRDN = this.decodeRDN(newRDNString, schema);
            message = Requests.newModifyDNRequest(dn, newRDN);
            message.setDeleteOldRDN(reader.readBoolean());
            if (reader.hasNextElement() && reader.peekType() == -128) {
                String newSuperiorString = reader.readOctetStringAsString((byte)-128);
                DN newSuperior = this.decodeDN(newSuperiorString, schema);
                message.setNewSuperior(newSuperior);
            }
        }
        finally {
            reader.readEndSequence();
        }
        this.decodeControls(reader, message);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("DECODE LDAP MODIFY DN REQUEST(messageID=%d, request=%s)", messageID, message));
        }
        handler.modifyDNRequest(p, messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P> void decodeModifyDNResult(ASN1Reader reader, int messageID, LDAPMessageHandler<P> handler, P p) throws IOException {
        Result message;
        reader.readStartSequence((byte)109);
        try {
            ResultCode resultCode = ResultCode.valueOf(reader.readEnumerated());
            String matchedDN = reader.readOctetStringAsString();
            String diagnosticMessage = reader.readOctetStringAsString();
            message = Responses.newResult(resultCode).setMatchedDN(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.decodeResponseReferrals(reader, message);
        }
        finally {
            reader.readEndSequence();
        }
        this.decodeControls(reader, message);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("DECODE LDAP MODIFY DN RESULT(messageID=%d, result=%s)", messageID, message));
        }
        handler.modifyDNResult(p, messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P> void decodeModifyRequest(ASN1Reader reader, int messageID, LDAPMessageHandler<P> handler, P p) throws IOException {
        ModifyRequest message;
        reader.readStartSequence((byte)102);
        try {
            String dnString = reader.readOctetStringAsString();
            Schema schema = this.options.getSchemaResolver().resolveSchema(dnString);
            DN dn = this.decodeDN(dnString, schema);
            message = Requests.newModifyRequest(dn);
            reader.readStartSequence();
            try {
                while (reader.hasNextElement()) {
                    reader.readStartSequence();
                    try {
                        int typeIntValue = reader.readEnumerated();
                        ModificationType type = ModificationType.valueOf(typeIntValue);
                        if (type == null) {
                            throw DecodeException.error(CoreMessages.ERR_LDAP_MODIFICATION_DECODE_INVALID_MOD_TYPE.get((Object)typeIntValue));
                        }
                        reader.readStartSequence();
                        try {
                            String ads = reader.readOctetStringAsString();
                            AttributeDescription ad = this.decodeAttributeDescription(ads, schema);
                            Attribute attribute = this.options.getAttributeFactory().newAttribute(ad);
                            reader.readStartSet();
                            try {
                                while (reader.hasNextElement()) {
                                    attribute.add(reader.readOctetString());
                                }
                                message.addModification(new Modification(type, attribute));
                            }
                            finally {
                                reader.readEndSet();
                            }
                        }
                        finally {
                            reader.readEndSequence();
                        }
                    }
                    finally {
                        reader.readEndSequence();
                    }
                }
            }
            finally {
                reader.readEndSequence();
            }
        }
        finally {
            reader.readEndSequence();
        }
        this.decodeControls(reader, message);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("DECODE LDAP MODIFY REQUEST(messageID=%d, request=%s)", messageID, message));
        }
        handler.modifyRequest(p, messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P> void decodeModifyResult(ASN1Reader reader, int messageID, LDAPMessageHandler<P> handler, P p) throws IOException {
        Result message;
        reader.readStartSequence((byte)103);
        try {
            ResultCode resultCode = ResultCode.valueOf(reader.readEnumerated());
            String matchedDN = reader.readOctetStringAsString();
            String diagnosticMessage = reader.readOctetStringAsString();
            message = Responses.newResult(resultCode).setMatchedDN(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.decodeResponseReferrals(reader, message);
        }
        finally {
            reader.readEndSequence();
        }
        this.decodeControls(reader, message);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("DECODE LDAP MODIFY RESULT(messageID=%d, result=%s)", messageID, message));
        }
        handler.modifyResult(p, messageID, message);
    }

    private <P> void decodeProtocolOp(ASN1Reader reader, int messageID, LDAPMessageHandler<P> handler, P p) throws IOException {
        byte type = reader.peekType();
        switch (type) {
            case 66: {
                this.decodeUnbindRequest(reader, messageID, handler, p);
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                handler.unrecognizedMessage(p, messageID, type, reader.readOctetString(type));
                break;
            }
            case 74: {
                this.decodeDeleteRequest(reader, messageID, handler, p);
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                handler.unrecognizedMessage(p, messageID, type, reader.readOctetString(type));
                break;
            }
            case 80: {
                this.decodeAbandonRequest(reader, messageID, handler, p);
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                handler.unrecognizedMessage(p, messageID, type, reader.readOctetString(type));
                break;
            }
            case 96: {
                this.decodeBindRequest(reader, messageID, handler, p);
                break;
            }
            case 97: {
                this.decodeBindResult(reader, messageID, handler, p);
                break;
            }
            case 98: {
                handler.unrecognizedMessage(p, messageID, type, reader.readOctetString(type));
                break;
            }
            case 99: {
                this.decodeSearchRequest(reader, messageID, handler, p);
                break;
            }
            case 100: {
                this.decodeSearchResultEntry(reader, messageID, handler, p);
                break;
            }
            case 101: {
                this.decodeSearchResult(reader, messageID, handler, p);
                break;
            }
            case 102: {
                this.decodeModifyRequest(reader, messageID, handler, p);
                break;
            }
            case 103: {
                this.decodeModifyResult(reader, messageID, handler, p);
                break;
            }
            case 104: {
                this.decodeAddRequest(reader, messageID, handler, p);
                break;
            }
            case 105: {
                this.decodeAddResult(reader, messageID, handler, p);
                break;
            }
            case 106: {
                handler.unrecognizedMessage(p, messageID, type, reader.readOctetString(type));
                break;
            }
            case 107: {
                this.decodeDeleteResult(reader, messageID, handler, p);
                break;
            }
            case 108: {
                this.decodeModifyDNRequest(reader, messageID, handler, p);
                break;
            }
            case 109: {
                this.decodeModifyDNResult(reader, messageID, handler, p);
                break;
            }
            case 110: {
                this.decodeCompareRequest(reader, messageID, handler, p);
                break;
            }
            case 111: {
                this.decodeCompareResult(reader, messageID, handler, p);
                break;
            }
            case 112: 
            case 113: 
            case 114: {
                handler.unrecognizedMessage(p, messageID, type, reader.readOctetString(type));
                break;
            }
            case 115: {
                this.decodeSearchResultReference(reader, messageID, handler, p);
                break;
            }
            case 116: 
            case 117: 
            case 118: {
                handler.unrecognizedMessage(p, messageID, type, reader.readOctetString(type));
                break;
            }
            case 119: {
                this.decodeExtendedRequest(reader, messageID, handler, p);
                break;
            }
            case 120: {
                this.decodeExtendedResult(reader, messageID, handler, p);
                break;
            }
            case 121: {
                this.decodeIntermediateResponse(reader, messageID, handler, p);
                break;
            }
            default: {
                handler.unrecognizedMessage(p, messageID, type, reader.readOctetString(type));
            }
        }
    }

    private RDN decodeRDN(String rdn, Schema schema) throws DecodeException {
        try {
            return RDN.valueOf(rdn, schema);
        }
        catch (LocalizedIllegalArgumentException e) {
            throw DecodeException.error(e.getMessageObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeResponseReferrals(ASN1Reader reader, Result message) throws IOException {
        if (reader.hasNextElement() && reader.peekType() == -93) {
            reader.readStartSequence((byte)-93);
            try {
                do {
                    message.addReferralURI(reader.readOctetStringAsString());
                } while (reader.hasNextElement());
            }
            finally {
                reader.readEndSequence();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P> void decodeSearchRequest(ASN1Reader reader, int messageID, LDAPMessageHandler<P> handler, P p) throws IOException {
        SearchRequest message;
        reader.readStartSequence((byte)99);
        try {
            String baseDNString = reader.readOctetStringAsString();
            Schema schema = this.options.getSchemaResolver().resolveSchema(baseDNString);
            DN baseDN = this.decodeDN(baseDNString, schema);
            int scopeIntValue = reader.readEnumerated();
            SearchScope scope = SearchScope.valueOf(scopeIntValue);
            if (scope == null) {
                throw DecodeException.error(CoreMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_INVALID_SCOPE.get((Object)scopeIntValue));
            }
            int dereferencePolicyIntValue = reader.readEnumerated();
            DereferenceAliasesPolicy dereferencePolicy = DereferenceAliasesPolicy.valueOf(dereferencePolicyIntValue);
            if (dereferencePolicy == null) {
                throw DecodeException.error(CoreMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_INVALID_DEREF.get((Object)dereferencePolicyIntValue));
            }
            int sizeLimit = (int)reader.readInteger();
            int timeLimit = (int)reader.readInteger();
            boolean typesOnly = reader.readBoolean();
            Filter filter = LDAPUtils.decodeFilter(reader);
            message = Requests.newSearchRequest(baseDN, scope, filter, new String[0]);
            message.setDereferenceAliasesPolicy(dereferencePolicy);
            try {
                message.setTimeLimit(timeLimit);
                message.setSizeLimit(sizeLimit);
            }
            catch (LocalizedIllegalArgumentException e) {
                throw DecodeException.error(e.getMessageObject());
            }
            message.setTypesOnly(typesOnly);
            reader.readStartSequence();
            try {
                while (reader.hasNextElement()) {
                    message.addAttribute(reader.readOctetStringAsString());
                }
            }
            finally {
                reader.readEndSequence();
            }
        }
        finally {
            reader.readEndSequence();
        }
        this.decodeControls(reader, message);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("DECODE LDAP SEARCH REQUEST(messageID=%d, request=%s)", messageID, message));
        }
        handler.searchRequest(p, messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P> void decodeSearchResult(ASN1Reader reader, int messageID, LDAPMessageHandler<P> handler, P p) throws IOException {
        Result message;
        reader.readStartSequence((byte)101);
        try {
            ResultCode resultCode = ResultCode.valueOf(reader.readEnumerated());
            String matchedDN = reader.readOctetStringAsString();
            String diagnosticMessage = reader.readOctetStringAsString();
            message = Responses.newResult(resultCode).setMatchedDN(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.decodeResponseReferrals(reader, message);
        }
        finally {
            reader.readEndSequence();
        }
        this.decodeControls(reader, message);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("DECODE LDAP SEARCH RESULT(messageID=%d, result=%s)", messageID, message));
        }
        handler.searchResult(p, messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P> void decodeSearchResultEntry(ASN1Reader reader, int messageID, LDAPMessageHandler<P> handler, P p) throws IOException {
        Entry entry;
        reader.readStartSequence((byte)100);
        try {
            String dnString = reader.readOctetStringAsString();
            Schema schema = this.options.getSchemaResolver().resolveSchema(dnString);
            DN dn = this.decodeDN(dnString, schema);
            entry = this.options.getEntryFactory().newEntry(dn);
            reader.readStartSequence();
            try {
                while (reader.hasNextElement()) {
                    reader.readStartSequence();
                    try {
                        String ads = reader.readOctetStringAsString();
                        AttributeDescription ad = this.decodeAttributeDescription(ads, schema);
                        Attribute attribute = this.options.getAttributeFactory().newAttribute(ad);
                        reader.readStartSet();
                        try {
                            while (reader.hasNextElement()) {
                                attribute.add(reader.readOctetString());
                            }
                            entry.addAttribute(attribute);
                        }
                        finally {
                            reader.readEndSet();
                        }
                    }
                    finally {
                        reader.readEndSequence();
                    }
                }
            }
            finally {
                reader.readEndSequence();
            }
        }
        finally {
            reader.readEndSequence();
        }
        SearchResultEntry message = Responses.newSearchResultEntry(entry);
        this.decodeControls(reader, message);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("DECODE LDAP SEARCH RESULT ENTRY(messageID=%d, entry=%s)", messageID, message));
        }
        handler.searchResultEntry(p, messageID, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P> void decodeSearchResultReference(ASN1Reader reader, int messageID, LDAPMessageHandler<P> handler, P p) throws IOException {
        SearchResultReference message;
        reader.readStartSequence((byte)115);
        try {
            message = Responses.newSearchResultReference(reader.readOctetStringAsString());
            while (reader.hasNextElement()) {
                message.addURI(reader.readOctetStringAsString());
            }
        }
        finally {
            reader.readEndSequence();
        }
        this.decodeControls(reader, message);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("DECODE LDAP SEARCH RESULT REFERENCE(messageID=%d, reference=%s)", messageID, message));
        }
        handler.searchResultReference(p, messageID, message);
    }

    private <P> void decodeUnbindRequest(ASN1Reader reader, int messageID, LDAPMessageHandler<P> handler, P p) throws IOException {
        reader.readNull((byte)66);
        UnbindRequest message = Requests.newUnbindRequest();
        this.decodeControls(reader, message);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("DECODE LDAP UNBIND REQUEST(messageID=%d, request=%s)", messageID, message));
        }
        handler.unbindRequest(p, messageID, message);
    }
}

