/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.ASN1BufferReader;
import com.forgerock.opendj.ldap.ASN1BufferWriter;
import com.forgerock.opendj.ldap.AbstractLDAPFutureResultImpl;
import com.forgerock.opendj.ldap.AbstractLDAPMessageHandler;
import com.forgerock.opendj.ldap.ConnectionSecurityLayerFilter;
import com.forgerock.opendj.ldap.LDAPBindFutureResultImpl;
import com.forgerock.opendj.ldap.LDAPCompareFutureResultImpl;
import com.forgerock.opendj.ldap.LDAPConnection;
import com.forgerock.opendj.ldap.LDAPExtendedFutureResultImpl;
import com.forgerock.opendj.ldap.LDAPFutureResultImpl;
import com.forgerock.opendj.ldap.LDAPReader;
import com.forgerock.opendj.ldap.LDAPSearchFutureResultImpl;
import com.forgerock.opendj.ldap.LDAPWriter;
import com.forgerock.opendj.ldap.UnexpectedResponseException;
import java.io.EOFException;
import java.io.IOException;
import javax.net.ssl.SSLEngine;
import org.forgerock.opendj.ldap.ConnectionSecurityLayer;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindClient;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.GenericBindRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.StartTLSExtendedRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.IntermediateResponse;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;

final class LDAPClientFilter
extends BaseFilter {
    private static final Attribute<LDAPConnection> LDAP_CONNECTION_ATTR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("LDAPClientConnection");
    private static final Attribute<ASN1BufferReader> LDAP_ASN1_READER_ATTR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("LDAPASN1Reader");
    private final int maxASN1ElementSize;
    private final LDAPReader ldapReader;
    private static final AbstractLDAPMessageHandler<FilterChainContext> CLIENT_RESPONSE_HANDLER = new AbstractLDAPMessageHandler<FilterChainContext>(){

        @Override
        public void addResult(FilterChainContext ctx, int messageID, Result result) throws UnexpectedResponseException, IOException {
            AbstractLDAPFutureResultImpl<?> pendingRequest;
            LDAPConnection ldapConnection = (LDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)ctx.getConnection());
            if (ldapConnection != null && (pendingRequest = ldapConnection.removePendingRequest(messageID)) != null) {
                LDAPFutureResultImpl future;
                if (pendingRequest instanceof LDAPFutureResultImpl && (future = (LDAPFutureResultImpl)pendingRequest).getRequest() instanceof AddRequest) {
                    future.setResultOrError(result);
                    return;
                }
                throw new UnexpectedResponseException(messageID, result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void bindResult(FilterChainContext ctx, int messageID, BindResult result) throws UnexpectedResponseException, IOException {
            AbstractLDAPFutureResultImpl<?> pendingRequest;
            LDAPConnection ldapConnection = (LDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)ctx.getConnection());
            if (ldapConnection != null && (pendingRequest = ldapConnection.removePendingRequest(messageID)) != null) {
                if (pendingRequest instanceof LDAPBindFutureResultImpl) {
                    ConnectionSecurityLayer l;
                    BindClient bindClient;
                    LDAPBindFutureResultImpl future;
                    block9: {
                        future = (LDAPBindFutureResultImpl)pendingRequest;
                        bindClient = future.getBindClient();
                        try {
                            if (bindClient.evaluateResult(result)) break block9;
                            int msgID = ldapConnection.continuePendingBindRequest(future);
                            ASN1BufferWriter asn1Writer = ASN1BufferWriter.getWriter();
                            try {
                                GenericBindRequest nextRequest = bindClient.nextBindRequest();
                                new LDAPWriter().bindRequest(asn1Writer, msgID, 3, nextRequest);
                                ctx.write((Object)asn1Writer.getBuffer(), null);
                            }
                            finally {
                                asn1Writer.recycle();
                            }
                            return;
                        }
                        catch (ErrorResultException e) {
                            ldapConnection.setBindOrStartTLSInProgress(false);
                            future.adaptErrorResult(e.getResult());
                            return;
                        }
                        catch (IOException e) {
                            ldapConnection.setBindOrStartTLSInProgress(false);
                            Result errorResult = Responses.newResult(ResultCode.CLIENT_SIDE_LOCAL_ERROR).setDiagnosticMessage("An error occurred during multi-stage authentication").setCause(e);
                            future.adaptErrorResult(errorResult);
                            return;
                        }
                    }
                    if (result.getResultCode() == ResultCode.SUCCESS && (l = bindClient.getConnectionSecurityLayer()) != null) {
                        ldapConnection.installFilter((Filter)new ConnectionSecurityLayerFilter(l, ctx.getConnection().getTransport().getMemoryManager()));
                    }
                    ldapConnection.setBindOrStartTLSInProgress(false);
                    future.setResultOrError(result);
                    return;
                }
                throw new UnexpectedResponseException(messageID, result);
            }
        }

        @Override
        public void compareResult(FilterChainContext ctx, int messageID, CompareResult result) throws UnexpectedResponseException, IOException {
            AbstractLDAPFutureResultImpl<?> pendingRequest;
            LDAPConnection ldapConnection = (LDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)ctx.getConnection());
            if (ldapConnection != null && (pendingRequest = ldapConnection.removePendingRequest(messageID)) != null) {
                if (pendingRequest instanceof LDAPCompareFutureResultImpl) {
                    LDAPCompareFutureResultImpl future = (LDAPCompareFutureResultImpl)pendingRequest;
                    future.setResultOrError(result);
                    return;
                }
                throw new UnexpectedResponseException(messageID, result);
            }
        }

        @Override
        public void deleteResult(FilterChainContext ctx, int messageID, Result result) throws UnexpectedResponseException, IOException {
            AbstractLDAPFutureResultImpl<?> pendingRequest;
            LDAPConnection ldapConnection = (LDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)ctx.getConnection());
            if (ldapConnection != null && (pendingRequest = ldapConnection.removePendingRequest(messageID)) != null) {
                LDAPFutureResultImpl future;
                if (pendingRequest instanceof LDAPFutureResultImpl && (future = (LDAPFutureResultImpl)pendingRequest).getRequest() instanceof DeleteRequest) {
                    future.setResultOrError(result);
                    return;
                }
                throw new UnexpectedResponseException(messageID, result);
            }
        }

        @Override
        public void extendedResult(FilterChainContext ctx, int messageID, ExtendedResult result) throws UnexpectedResponseException, IOException {
            LDAPConnection ldapConnection = (LDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)ctx.getConnection());
            if (ldapConnection != null) {
                if (messageID == 0) {
                    if (result.getOID() != null && result.getOID().equals("1.3.6.1.4.1.1466.20036")) {
                        Result errorResult = Responses.newResult(result.getResultCode()).setDiagnosticMessage(result.getDiagnosticMessage());
                        ldapConnection.close(null, true, errorResult);
                    } else {
                        ldapConnection.handleUnsolicitedNotification(result);
                    }
                } else {
                    AbstractLDAPFutureResultImpl<?> pendingRequest = ldapConnection.removePendingRequest(messageID);
                    if (pendingRequest != null) {
                        if (pendingRequest instanceof LDAPExtendedFutureResultImpl) {
                            LDAPExtendedFutureResultImpl extendedFuture = (LDAPExtendedFutureResultImpl)pendingRequest;
                            try {
                                this.handleExtendedResult0(ldapConnection, extendedFuture, result);
                            }
                            catch (DecodeException de) {
                                Result errorResult = Responses.newResult(ResultCode.CLIENT_SIDE_DECODING_ERROR).setDiagnosticMessage(de.getLocalizedMessage()).setCause(de);
                                extendedFuture.adaptErrorResult(errorResult);
                            }
                        } else {
                            throw new UnexpectedResponseException(messageID, result);
                        }
                    }
                }
            }
        }

        @Override
        public void intermediateResponse(FilterChainContext ctx, int messageID, IntermediateResponse response) throws UnexpectedResponseException, IOException {
            AbstractLDAPFutureResultImpl<?> pendingRequest;
            LDAPConnection ldapConnection = (LDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)ctx.getConnection());
            if (ldapConnection != null && (pendingRequest = ldapConnection.getPendingRequest(messageID)) != null) {
                pendingRequest.handleIntermediateResponse(response);
            }
        }

        @Override
        public void modifyDNResult(FilterChainContext ctx, int messageID, Result result) throws UnexpectedResponseException, IOException {
            AbstractLDAPFutureResultImpl<?> pendingRequest;
            LDAPConnection ldapConnection = (LDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)ctx.getConnection());
            if (ldapConnection != null && (pendingRequest = ldapConnection.removePendingRequest(messageID)) != null) {
                LDAPFutureResultImpl future;
                if (pendingRequest instanceof LDAPFutureResultImpl && (future = (LDAPFutureResultImpl)pendingRequest).getRequest() instanceof ModifyDNRequest) {
                    future.setResultOrError(result);
                    return;
                }
                throw new UnexpectedResponseException(messageID, result);
            }
        }

        @Override
        public void modifyResult(FilterChainContext ctx, int messageID, Result result) throws UnexpectedResponseException, IOException {
            AbstractLDAPFutureResultImpl<?> pendingRequest;
            LDAPConnection ldapConnection = (LDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)ctx.getConnection());
            if (ldapConnection != null && (pendingRequest = ldapConnection.removePendingRequest(messageID)) != null) {
                LDAPFutureResultImpl future;
                if (pendingRequest instanceof LDAPFutureResultImpl && (future = (LDAPFutureResultImpl)pendingRequest).getRequest() instanceof ModifyRequest) {
                    future.setResultOrError(result);
                    return;
                }
                throw new UnexpectedResponseException(messageID, result);
            }
        }

        @Override
        public void searchResult(FilterChainContext ctx, int messageID, Result result) throws UnexpectedResponseException, IOException {
            AbstractLDAPFutureResultImpl<?> pendingRequest;
            LDAPConnection ldapConnection = (LDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)ctx.getConnection());
            if (ldapConnection != null && (pendingRequest = ldapConnection.removePendingRequest(messageID)) != null) {
                if (pendingRequest instanceof LDAPSearchFutureResultImpl) {
                    ((LDAPSearchFutureResultImpl)pendingRequest).setResultOrError(result);
                } else {
                    throw new UnexpectedResponseException(messageID, result);
                }
            }
        }

        @Override
        public void searchResultEntry(FilterChainContext ctx, int messageID, SearchResultEntry entry) throws UnexpectedResponseException, IOException {
            AbstractLDAPFutureResultImpl<?> pendingRequest;
            LDAPConnection ldapConnection = (LDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)ctx.getConnection());
            if (ldapConnection != null && (pendingRequest = ldapConnection.getPendingRequest(messageID)) != null) {
                if (pendingRequest instanceof LDAPSearchFutureResultImpl) {
                    ((LDAPSearchFutureResultImpl)pendingRequest).handleEntry(entry);
                } else {
                    throw new UnexpectedResponseException(messageID, entry);
                }
            }
        }

        @Override
        public void searchResultReference(FilterChainContext ctx, int messageID, SearchResultReference reference) throws UnexpectedResponseException, IOException {
            AbstractLDAPFutureResultImpl<?> pendingRequest;
            LDAPConnection ldapConnection = (LDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)ctx.getConnection());
            if (ldapConnection != null && (pendingRequest = ldapConnection.getPendingRequest(messageID)) != null) {
                if (pendingRequest instanceof LDAPSearchFutureResultImpl) {
                    ((LDAPSearchFutureResultImpl)pendingRequest).handleReference(reference);
                } else {
                    throw new UnexpectedResponseException(messageID, reference);
                }
            }
        }

        private <R extends ExtendedResult> void handleExtendedResult0(final LDAPConnection conn, final LDAPExtendedFutureResultImpl<R> future, ExtendedResult result) throws DecodeException {
            final R decodedResponse = future.decodeResult(result, conn.getLDAPOptions().getDecodeOptions());
            if (future.getRequest() instanceof StartTLSExtendedRequest && result.getResultCode() == ResultCode.SUCCESS) {
                try {
                    StartTLSExtendedRequest request = (StartTLSExtendedRequest)future.getRequest();
                    conn.startTLS(request.getSSLContext(), request.getEnabledProtocols(), request.getEnabledCipherSuites(), (CompletionHandler<SSLEngine>)new EmptyCompletionHandler<SSLEngine>(){

                        public void completed(SSLEngine result) {
                            conn.setBindOrStartTLSInProgress(false);
                            future.setResultOrError(decodedResponse);
                        }

                        public void failed(Throwable throwable) {
                            Result errorResult = Responses.newResult(ResultCode.CLIENT_SIDE_LOCAL_ERROR).setCause(throwable).setDiagnosticMessage("SSL handshake failed");
                            conn.setBindOrStartTLSInProgress(false);
                            conn.close(null, false, errorResult);
                            future.adaptErrorResult(errorResult);
                        }
                    });
                    return;
                }
                catch (IOException e) {
                    Result errorResult = Responses.newResult(ResultCode.CLIENT_SIDE_LOCAL_ERROR).setCause(e).setDiagnosticMessage(e.getMessage());
                    future.adaptErrorResult(errorResult);
                    conn.close(null, false, errorResult);
                    return;
                }
            }
            future.setResultOrError(decodedResponse);
        }
    };

    LDAPClientFilter(LDAPReader ldapReader, int maxASN1ElementSize) {
        this.ldapReader = ldapReader;
        this.maxASN1ElementSize = maxASN1ElementSize;
    }

    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
        Connection connection = ctx.getConnection();
        if (!connection.isOpen()) {
            return;
        }
        LDAPConnection ldapConnection = (LDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)connection);
        Result errorResult = error instanceof EOFException ? Responses.newResult(ResultCode.CLIENT_SIDE_SERVER_DOWN).setCause(error) : Responses.newResult(ResultCode.CLIENT_SIDE_LOCAL_ERROR).setCause(error);
        ldapConnection.close(null, false, errorResult);
    }

    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        LDAPConnection ldapConnection = (LDAPConnection)LDAP_CONNECTION_ATTR.remove((AttributeStorage)connection);
        if (ldapConnection != null) {
            Result errorResult = Responses.newResult(ResultCode.CLIENT_SIDE_SERVER_DOWN);
            ldapConnection.close(null, false, errorResult);
        }
        return ctx.getInvokeAction();
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer buffer = (Buffer)ctx.getMessage();
        ASN1BufferReader asn1Reader = (ASN1BufferReader)LDAP_ASN1_READER_ATTR.get((AttributeStorage)ctx.getConnection());
        if (asn1Reader == null) {
            asn1Reader = new ASN1BufferReader(this.maxASN1ElementSize, ctx.getConnection().getTransport().getMemoryManager());
            LDAP_ASN1_READER_ATTR.set((AttributeStorage)ctx.getConnection(), (Object)asn1Reader);
        }
        asn1Reader.appendBytesRead(buffer);
        try {
            while (asn1Reader.elementAvailable()) {
                this.ldapReader.decode(asn1Reader, CLIENT_RESPONSE_HANDLER, ctx);
            }
        }
        catch (IOException ioe) {
            LDAPConnection ldapConnection = (LDAPConnection)LDAP_CONNECTION_ATTR.get((AttributeStorage)ctx.getConnection());
            Result errorResult = Responses.newResult(ResultCode.CLIENT_SIDE_DECODING_ERROR).setCause(ioe).setDiagnosticMessage(ioe.getMessage());
            ldapConnection.close(null, false, errorResult);
            throw ioe;
        }
        finally {
            asn1Reader.disposeBytesRead();
        }
        return ctx.getStopAction();
    }

    void registerConnection(Connection<?> connection, LDAPConnection ldapConnection) {
        LDAP_CONNECTION_ATTR.set(connection, (Object)ldapConnection);
    }
}

