/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap;

import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.asn1.ASN1Writer;
import org.forgerock.opendj.asn1.AbstractASN1Writer;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.CoreMessages;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.memory.ByteBufferWrapper;

final class ASN1BufferWriter
extends AbstractASN1Writer
implements ASN1Writer,
Cacheable {
    private static final int BUFFER_INIT_SIZE = 1024;
    private static final ThreadCache.CachedTypeIndex<ASN1BufferWriter> WRITER_INDEX = ThreadCache.obtainIndex(ASN1BufferWriter.class, (int)1);
    private SequenceBuffer sequenceBuffer;
    private RecyclableBuffer outBuffer;
    private final RootSequenceBuffer rootBuffer = new RootSequenceBuffer();

    static ASN1BufferWriter getWriter() {
        ASN1BufferWriter asn1Writer = (ASN1BufferWriter)ThreadCache.takeFromCache(WRITER_INDEX);
        if (asn1Writer == null) {
            asn1Writer = new ASN1BufferWriter();
        }
        if (!asn1Writer.outBuffer.usable) {
            asn1Writer.outBuffer = new RecyclableBuffer();
        }
        asn1Writer.outBuffer.clear();
        return asn1Writer;
    }

    private ASN1BufferWriter() {
        this.sequenceBuffer = this.rootBuffer;
        this.outBuffer = new RecyclableBuffer();
    }

    @Override
    public void close() throws IOException {
        this.outBuffer = null;
    }

    @Override
    public void flush() throws IOException {
    }

    public void recycle() {
        this.sequenceBuffer = this.rootBuffer;
        this.outBuffer.clear();
        ThreadCache.putToCache(WRITER_INDEX, (Object)this);
    }

    @Override
    public ASN1Writer writeBoolean(byte type, boolean booleanValue) throws IOException {
        this.sequenceBuffer.writeByte(type);
        this.writeLength(this.sequenceBuffer, 1);
        this.sequenceBuffer.writeByte(booleanValue ? (byte)-1 : 0);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
            StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 BOOLEAN(type=0x%x, length=%d, value=%s)", type, 1, String.valueOf(booleanValue)));
        }
        return this;
    }

    @Override
    public ASN1Writer writeEndSequence() throws IOException {
        this.sequenceBuffer = this.sequenceBuffer.endSequence();
        return this;
    }

    @Override
    public ASN1Writer writeEndSet() throws IOException {
        return this.writeEndSequence();
    }

    @Override
    public ASN1Writer writeEnumerated(byte type, int intValue) throws IOException {
        return this.writeInteger(type, intValue);
    }

    @Override
    public ASN1Writer writeInteger(byte type, int intValue) throws IOException {
        this.sequenceBuffer.writeByte(type);
        if (intValue < 0 && (intValue & 0xFFFFFF80) == -128 || (intValue & 0x7F) == intValue) {
            this.writeLength(this.sequenceBuffer, 1);
            this.sequenceBuffer.writeByte((byte)(intValue & 0xFF));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 1, intValue));
            }
        } else if (intValue < 0 && (intValue & Short.MIN_VALUE) == Short.MIN_VALUE || (intValue & Short.MAX_VALUE) == intValue) {
            this.writeLength(this.sequenceBuffer, 2);
            this.sequenceBuffer.writeByte((byte)(intValue >> 8 & 0xFF));
            this.sequenceBuffer.writeByte((byte)(intValue & 0xFF));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 2, intValue));
            }
        } else if (intValue < 0 && (intValue & 0xFF800000) == -8388608 || (intValue & 0x7FFFFF) == intValue) {
            this.writeLength(this.sequenceBuffer, 3);
            this.sequenceBuffer.writeByte((byte)(intValue >> 16 & 0xFF));
            this.sequenceBuffer.writeByte((byte)(intValue >> 8 & 0xFF));
            this.sequenceBuffer.writeByte((byte)(intValue & 0xFF));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 3, intValue));
            }
        } else {
            this.writeLength(this.sequenceBuffer, 4);
            this.sequenceBuffer.writeByte((byte)(intValue >> 24 & 0xFF));
            this.sequenceBuffer.writeByte((byte)(intValue >> 16 & 0xFF));
            this.sequenceBuffer.writeByte((byte)(intValue >> 8 & 0xFF));
            this.sequenceBuffer.writeByte((byte)(intValue & 0xFF));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 4, intValue));
            }
        }
        return this;
    }

    @Override
    public ASN1Writer writeInteger(byte type, long longValue) throws IOException {
        this.sequenceBuffer.writeByte(type);
        if (longValue < 0L && (longValue & 0xFFFFFFFFFFFFFF80L) == -128L || (longValue & 0x7FL) == longValue) {
            this.writeLength(this.sequenceBuffer, 1);
            this.sequenceBuffer.writeByte((byte)(longValue & 0xFFL));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 1, longValue));
            }
        } else if (longValue < 0L && (longValue & 0xFFFFFFFFFFFF8000L) == -32768L || (longValue & 0x7FFFL) == longValue) {
            this.writeLength(this.sequenceBuffer, 2);
            this.sequenceBuffer.writeByte((byte)(longValue >> 8 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue & 0xFFL));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 2, longValue));
            }
        } else if (longValue < 0L && (longValue & 0xFFFFFFFFFF800000L) == -8388608L || (longValue & 0x7FFFFFL) == longValue) {
            this.writeLength(this.sequenceBuffer, 3);
            this.sequenceBuffer.writeByte((byte)(longValue >> 16 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue >> 8 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue & 0xFFL));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 3, longValue));
            }
        } else if (longValue < 0L && (longValue & Integer.MIN_VALUE) == Integer.MIN_VALUE || (longValue & Integer.MAX_VALUE) == longValue) {
            this.writeLength(this.sequenceBuffer, 4);
            this.sequenceBuffer.writeByte((byte)(longValue >> 24 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue >> 16 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue >> 8 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue & 0xFFL));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 4, longValue));
            }
        } else if (longValue < 0L && (longValue & 0xFFFFFF8000000000L) == -549755813888L || (longValue & 0x7FFFFFFFFFL) == longValue) {
            this.writeLength(this.sequenceBuffer, 5);
            this.sequenceBuffer.writeByte((byte)(longValue >> 32 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue >> 24 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue >> 16 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue >> 8 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue & 0xFFL));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 5, longValue));
            }
        } else if (longValue < 0L && (longValue & 0xFFFF800000000000L) == -140737488355328L || (longValue & 0x7FFFFFFFFFFFL) == longValue) {
            this.writeLength(this.sequenceBuffer, 6);
            this.sequenceBuffer.writeByte((byte)(longValue >> 40 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue >> 32 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue >> 24 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue >> 16 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue >> 8 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue & 0xFFL));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 6, longValue));
            }
        } else if (longValue < 0L && (longValue & 0xFF80000000000000L) == -36028797018963968L || (longValue & 0x7FFFFFFFFFFFFFL) == longValue) {
            this.writeLength(this.sequenceBuffer, 7);
            this.sequenceBuffer.writeByte((byte)(longValue >> 48 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue >> 40 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue >> 32 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue >> 24 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue >> 16 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue >> 8 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue & 0xFFL));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 7, longValue));
            }
        } else {
            this.writeLength(this.sequenceBuffer, 8);
            this.sequenceBuffer.writeByte((byte)(longValue >> 56 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue >> 48 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue >> 40 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue >> 32 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue >> 24 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue >> 16 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue >> 8 & 0xFFL));
            this.sequenceBuffer.writeByte((byte)(longValue & 0xFFL));
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", type, 8, longValue));
            }
        }
        return this;
    }

    @Override
    public ASN1Writer writeNull(byte type) throws IOException {
        this.sequenceBuffer.writeByte(type);
        this.writeLength(this.sequenceBuffer, 0);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
            StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 NULL(type=0x%x, length=%d)", type, 0));
        }
        return this;
    }

    @Override
    public ASN1Writer writeOctetString(byte type, byte[] value, int offset, int length) throws IOException {
        this.sequenceBuffer.writeByte(type);
        this.writeLength(this.sequenceBuffer, length);
        this.sequenceBuffer.writeByteArray(value, offset, length);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
            StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 OCTETSTRING(type=0x%x, length=%d)", type, length));
        }
        return this;
    }

    @Override
    public ASN1Writer writeOctetString(byte type, ByteSequence value) throws IOException {
        this.sequenceBuffer.writeByte(type);
        this.writeLength(this.sequenceBuffer, value.length());
        for (int i = 0; i < value.length(); ++i) {
            this.sequenceBuffer.writeByte(value.byteAt(i));
        }
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
            StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 OCTETSTRING(type=0x%x, length=%d)", type, value.length()));
        }
        return this;
    }

    @Override
    public ASN1Writer writeOctetString(byte type, String value) throws IOException {
        this.sequenceBuffer.writeByte(type);
        if (value == null) {
            this.writeLength(this.sequenceBuffer, 0);
            return this;
        }
        byte[] bytes = StaticUtils.getBytes(value);
        this.writeLength(this.sequenceBuffer, bytes.length);
        this.sequenceBuffer.writeByteArray(bytes, 0, bytes.length);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
            StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 OCTETSTRING(type=0x%x, length=%d, value=%s)", type, bytes.length, value));
        }
        return this;
    }

    @Override
    public ASN1Writer writeStartSequence(byte type) throws IOException {
        this.sequenceBuffer = this.sequenceBuffer.startSequence(type);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
            StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 START SEQUENCE(type=0x%x)", type));
        }
        return this;
    }

    @Override
    public ASN1Writer writeStartSet(byte type) throws IOException {
        return this.writeStartSequence(type);
    }

    Buffer getBuffer() {
        this.outBuffer.usable = false;
        return this.outBuffer.flip();
    }

    private void writeLength(SequenceBuffer buffer, int length) throws IOException {
        if (length < 128) {
            buffer.writeByte((byte)length);
        } else if ((length & 0xFF) == length) {
            buffer.writeByte((byte)-127);
            buffer.writeByte((byte)(length & 0xFF));
        } else if ((length & 0xFFFF) == length) {
            buffer.writeByte((byte)-126);
            buffer.writeByte((byte)(length >> 8 & 0xFF));
            buffer.writeByte((byte)(length & 0xFF));
        } else if ((length & 0xFFFFFF) == length) {
            buffer.writeByte((byte)-125);
            buffer.writeByte((byte)(length >> 16 & 0xFF));
            buffer.writeByte((byte)(length >> 8 & 0xFF));
            buffer.writeByte((byte)(length & 0xFF));
        } else {
            buffer.writeByte((byte)-124);
            buffer.writeByte((byte)(length >> 24 & 0xFF));
            buffer.writeByte((byte)(length >> 16 & 0xFF));
            buffer.writeByte((byte)(length >> 8 & 0xFF));
            buffer.writeByte((byte)(length & 0xFF));
        }
    }

    private static interface SequenceBuffer {
        public SequenceBuffer endSequence() throws IOException;

        public SequenceBuffer startSequence(byte var1) throws IOException;

        public void writeByte(byte var1) throws IOException;

        public void writeByteArray(byte[] var1, int var2, int var3) throws IOException;
    }

    private class RootSequenceBuffer
    implements SequenceBuffer {
        private ChildSequenceBuffer child;

        private RootSequenceBuffer() {
        }

        @Override
        public SequenceBuffer endSequence() throws IOException {
            LocalizableMessage message = CoreMessages.ERR_ASN1_SEQUENCE_WRITE_NOT_STARTED.get();
            throw new IllegalStateException(message.toString());
        }

        @Override
        public SequenceBuffer startSequence(byte type) throws IOException {
            if (this.child == null) {
                this.child = new ChildSequenceBuffer();
                this.child.parent = this;
            }
            ASN1BufferWriter.this.outBuffer.ensureAdditionalCapacity(1);
            ASN1BufferWriter.this.outBuffer.put(type);
            this.child.buffer.clear();
            return this.child;
        }

        @Override
        public void writeByte(byte b) throws IOException {
            ASN1BufferWriter.this.outBuffer.ensureAdditionalCapacity(1);
            ASN1BufferWriter.this.outBuffer.put(b);
        }

        @Override
        public void writeByteArray(byte[] bs, int offset, int length) throws IOException {
            ASN1BufferWriter.this.outBuffer.ensureAdditionalCapacity(length);
            ASN1BufferWriter.this.outBuffer.put(bs, offset, length);
        }
    }

    private static final class RecyclableBuffer
    extends ByteBufferWrapper {
        private volatile boolean usable = true;

        private RecyclableBuffer() {
            this.visible = ByteBuffer.allocate(1024);
            this.allowBufferDispose = true;
        }

        public void dispose() {
            this.usable = true;
        }

        public void ensureAdditionalCapacity(int size) {
            int newCount = this.visible.position() + size;
            if (newCount > this.visible.capacity()) {
                ByteBuffer newByteBuffer = ByteBuffer.allocate(Math.max(this.visible.capacity() << 1, newCount));
                this.visible.flip();
                this.visible = newByteBuffer.put(this.visible);
            }
        }
    }

    private class ChildSequenceBuffer
    implements SequenceBuffer {
        private SequenceBuffer parent;
        private ChildSequenceBuffer child;
        private final ByteStringBuilder buffer = new ByteStringBuilder(1024);

        private ChildSequenceBuffer() {
        }

        @Override
        public SequenceBuffer endSequence() throws IOException {
            ASN1BufferWriter.this.writeLength(this.parent, this.buffer.length());
            this.parent.writeByteArray(this.buffer.getBackingArray(), 0, this.buffer.length());
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
                StaticUtils.DEBUG_LOG.finest(String.format("WRITE ASN.1 END SEQUENCE(length=%d)", this.buffer.length()));
            }
            return this.parent;
        }

        @Override
        public SequenceBuffer startSequence(byte type) throws IOException {
            if (this.child == null) {
                this.child = new ChildSequenceBuffer();
                this.child.parent = this;
            }
            this.buffer.append(type);
            this.child.buffer.clear();
            return this.child;
        }

        @Override
        public void writeByte(byte b) throws IOException {
            this.buffer.append(b);
        }

        @Override
        public void writeByteArray(byte[] bs, int offset, int length) throws IOException {
            this.buffer.append(bs, offset, length);
        }
    }
}

